/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.httpclient;

import java.io.IOException;
import java.util.Optional;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;
import org.zalando.logbook.Correlator;
import org.zalando.logbook.RawHttpResponse;
import org.zalando.logbook.httpclient.Attributes;
import org.zalando.logbook.httpclient.RemoteResponse;

public final class LogbookHttpResponseInterceptor
implements HttpResponseInterceptor {
    public void process(HttpResponse original, HttpContext context) throws HttpException, IOException {
        Optional<Correlator> correlator = this.findCorrelator(context);
        if (correlator.isPresent()) {
            correlator.get().write((RawHttpResponse)new RemoteResponse(original));
        }
    }

    private Optional<Correlator> findCorrelator(HttpContext context) {
        return Optional.ofNullable(context.getAttribute(Attributes.CORRELATOR)).map(Correlator.class::cast);
    }
}

