/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.httpclient;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.zalando.fauxpas.FauxPas;
import org.zalando.logbook.Headers;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Origin;

final class RemoteResponse
implements HttpResponse {
    private final AtomicReference<State> state = new AtomicReference<Unbuffered>(new Unbuffered());
    private final org.apache.http.HttpResponse response;

    public Origin getOrigin() {
        return Origin.REMOTE;
    }

    public String getProtocolVersion() {
        return this.response.getStatusLine().getProtocolVersion().toString();
    }

    public int getStatus() {
        return this.response.getStatusLine().getStatusCode();
    }

    public Map<String, List<String>> getHeaders() {
        Map headers = Headers.empty();
        Stream.of(this.response.getAllHeaders()).collect(Collectors.groupingBy(NameValuePair::getName, Collectors.mapping(NameValuePair::getValue, Collectors.toList()))).forEach(headers::put);
        return headers;
    }

    public String getContentType() {
        return Optional.of(this.response).map(response -> response.getFirstHeader("Content-Type")).map(NameValuePair::getValue).orElse("");
    }

    public Charset getCharset() {
        return Optional.of(this.response).map(response -> response.getFirstHeader("Content-Type")).map(NameValuePair::getValue).map(ContentType::parse).map(ContentType::getCharset).orElse(StandardCharsets.UTF_8);
    }

    public HttpResponse withBody() throws IOException {
        this.state.updateAndGet(State::with);
        return this;
    }

    public RemoteResponse withoutBody() {
        this.state.updateAndGet(State::without);
        return this;
    }

    public byte[] getBody() {
        return this.state.updateAndGet((UnaryOperator<State>)FauxPas.throwingUnaryOperator(state -> state.buffer(this.response))).getBody();
    }

    public RemoteResponse(org.apache.http.HttpResponse response) {
        this.response = response;
    }

    private static final class Passing
    implements State {
        private Passing() {
        }
    }

    private static final class Ignoring
    implements State {
        private final byte[] body;

        @Override
        public State with() {
            return new Buffering(this.body);
        }

        public Ignoring(byte[] body) {
            this.body = body;
        }
    }

    private static final class Buffering
    implements State {
        private final byte[] body;

        @Override
        public State without() {
            return new Ignoring(this.body);
        }

        @Override
        public byte[] getBody() {
            return this.body;
        }

        public Buffering(byte[] body) {
            this.body = body;
        }
    }

    private static final class Offering
    implements State {
        private Offering() {
        }

        @Override
        public State without() {
            return new Unbuffered();
        }

        @Override
        public State buffer(org.apache.http.HttpResponse response) throws IOException {
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                return new Passing();
            }
            byte[] body = EntityUtils.toByteArray((HttpEntity)entity);
            ByteArrayEntity copy = new ByteArrayEntity(body);
            copy.setChunked(entity.isChunked());
            copy.setContentEncoding(entity.getContentEncoding());
            copy.setContentType(entity.getContentType());
            response.setEntity((HttpEntity)copy);
            return new Buffering(body);
        }
    }

    private static final class Unbuffered
    implements State {
        private Unbuffered() {
        }

        @Override
        public State with() {
            return new Offering();
        }
    }

    private static interface State {
        default public State with() {
            return this;
        }

        default public State without() {
            return this;
        }

        default public State buffer(org.apache.http.HttpResponse response) throws IOException {
            return this;
        }

        default public byte[] getBody() {
            return new byte[0];
        }
    }
}

