/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.httpclient;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.entity.ContentType;
import org.zalando.fauxpas.FauxPas;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Origin;
import org.zalando.logbook.httpclient.HttpEntities;

final class RemoteResponse
implements HttpResponse {
    private final AtomicReference<State> state = new AtomicReference<Unbuffered>(new Unbuffered());
    private final org.apache.http.HttpResponse response;

    public Origin getOrigin() {
        return Origin.REMOTE;
    }

    public String getProtocolVersion() {
        return this.response.getStatusLine().getProtocolVersion().toString();
    }

    public int getStatus() {
        return this.response.getStatusLine().getStatusCode();
    }

    public HttpHeaders getHeaders() {
        HttpHeaders headers = HttpHeaders.empty();
        Set entries = Stream.of(this.response.getAllHeaders()).collect(Collectors.groupingBy(NameValuePair::getName, Collectors.mapping(NameValuePair::getValue, Collectors.toList()))).entrySet();
        for (Map.Entry entry : entries) {
            String name = entry.getKey();
            List values = entry.getValue();
            headers = headers.update(name, values);
        }
        return headers;
    }

    public String getContentType() {
        return Optional.of(this.response).map(response -> response.getFirstHeader("Content-Type")).map(NameValuePair::getValue).orElse("");
    }

    public Charset getCharset() {
        return Optional.of(this.response).map(response -> response.getFirstHeader("Content-Type")).map(NameValuePair::getValue).map(ContentType::parse).map(ContentType::getCharset).orElse(StandardCharsets.UTF_8);
    }

    public HttpResponse withBody() throws IOException {
        this.state.updateAndGet(State::with);
        return this;
    }

    public RemoteResponse withoutBody() {
        this.state.updateAndGet(State::without);
        return this;
    }

    public byte[] getBody() {
        return this.state.updateAndGet((UnaryOperator<State>)FauxPas.throwingUnaryOperator(state -> state.buffer(this.response))).getBody();
    }

    @Generated
    public RemoteResponse(org.apache.http.HttpResponse response) {
        this.response = response;
    }

    private static interface State {
        default public State with() {
            return this;
        }

        default public State without() {
            return this;
        }

        default public State buffer(org.apache.http.HttpResponse response) throws IOException {
            return this;
        }

        default public byte[] getBody() {
            return new byte[0];
        }
    }

    private static final class Unbuffered
    implements State {
        private Unbuffered() {
        }

        @Override
        public State with() {
            return new Offering();
        }
    }

    private static final class Passing
    implements State {
        private Passing() {
        }
    }

    private static final class Ignoring
    implements State {
        private final Buffering buffering;

        @Override
        public State with() {
            return this.buffering;
        }

        @Generated
        public Ignoring(Buffering buffering) {
            this.buffering = buffering;
        }
    }

    private static final class Buffering
    implements State {
        private final byte[] body;

        @Override
        public State without() {
            return new Ignoring(this);
        }

        @Override
        public byte[] getBody() {
            return this.body;
        }

        @Generated
        public Buffering(byte[] body) {
            this.body = body;
        }
    }

    private static final class Offering
    implements State {
        private Offering() {
        }

        @Override
        public State without() {
            return new Unbuffered();
        }

        @Override
        public State buffer(org.apache.http.HttpResponse response) throws IOException {
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                return new Passing();
            }
            HttpEntities.Copy copy = HttpEntities.copy(entity);
            response.setEntity((HttpEntity)copy);
            return new Buffering(copy.getBody());
        }
    }
}

