/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.httpclient;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import lombok.Generated;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.entity.ContentType;
import org.zalando.fauxpas.FauxPas;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Origin;
import org.zalando.logbook.httpclient.HttpEntities;

final class RemoteResponse
implements HttpResponse {
    private final AtomicReference<State> state = new AtomicReference<Unbuffered>(new Unbuffered());
    private final org.apache.http.HttpResponse response;
    private final boolean decompressResponse;

    public Origin getOrigin() {
        return Origin.REMOTE;
    }

    public String getProtocolVersion() {
        return this.response.getStatusLine().getProtocolVersion().toString();
    }

    public int getStatus() {
        return this.response.getStatusLine().getStatusCode();
    }

    public HttpHeaders getHeaders() {
        HttpHeaders headers = HttpHeaders.empty();
        Set entries = Stream.of(this.response.getAllHeaders()).collect(Collectors.groupingBy(NameValuePair::getName, Collectors.mapping(NameValuePair::getValue, Collectors.toList()))).entrySet();
        for (Map.Entry entry : entries) {
            String name = entry.getKey();
            List values = entry.getValue();
            headers = headers.update(name, values);
        }
        return headers;
    }

    public String getContentType() {
        return Optional.of(this.response).map(response -> response.getFirstHeader("Content-Type")).map(NameValuePair::getValue).orElse("");
    }

    public Charset getCharset() {
        return Optional.of(this.response).map(response -> response.getFirstHeader("Content-Type")).map(NameValuePair::getValue).map(ContentType::parse).map(ContentType::getCharset).orElse(StandardCharsets.UTF_8);
    }

    public HttpResponse withBody() throws IOException {
        this.state.updateAndGet(State::with);
        return this;
    }

    public RemoteResponse withoutBody() {
        this.state.updateAndGet(State::without);
        return this;
    }

    private static byte[] getDecompressedBytes(byte[] body) throws IOException {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(body);){
            byte[] byArray;
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                int bytesRead;
                GZIPInputStream gzipInputStream = new GZIPInputStream(inputStream);
                byte[] buffer = new byte[1024];
                while ((bytesRead = gzipInputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
                byArray = outputStream.toByteArray();
            }
            return byArray;
        }
    }

    public byte[] getBody() throws IOException {
        byte[] body = this.state.updateAndGet((UnaryOperator<State>)FauxPas.throwingUnaryOperator(s -> s.buffer(this.response))).getBody();
        if (this.decompressResponse && this.isGzip()) {
            return RemoteResponse.getDecompressedBytes(body);
        }
        return body;
    }

    private boolean isGzip() {
        if (this.response.containsHeader("Content-Encoding")) {
            Header[] headers = this.response.getHeaders("Content-Encoding");
            return Arrays.stream(headers).anyMatch(this::isGzipHeaderRepresentation);
        }
        return false;
    }

    private boolean isGzipHeaderRepresentation(Header header) {
        if ("gzip".equalsIgnoreCase(header.getValue())) {
            return true;
        }
        return "x-gzip".equalsIgnoreCase(header.getValue());
    }

    @Generated
    public RemoteResponse(org.apache.http.HttpResponse response, boolean decompressResponse) {
        this.response = response;
        this.decompressResponse = decompressResponse;
    }

    private static interface State {
        default public State with() {
            return this;
        }

        default public State without() {
            return this;
        }

        default public State buffer(org.apache.http.HttpResponse response) throws IOException {
            return this;
        }

        default public byte[] getBody() {
            return new byte[0];
        }
    }

    private static final class Unbuffered
    implements State {
        private Unbuffered() {
        }

        @Override
        public State with() {
            return new Offering();
        }
    }

    private static final class Passing
    implements State {
        private Passing() {
        }
    }

    private static final class Ignoring
    implements State {
        private final Buffering buffering;

        @Override
        public State with() {
            return this.buffering;
        }

        @Generated
        public Ignoring(Buffering buffering) {
            this.buffering = buffering;
        }
    }

    private static final class Buffering
    implements State {
        private final byte[] body;

        @Override
        public State without() {
            return new Ignoring(this);
        }

        @Override
        public byte[] getBody() {
            return this.body;
        }

        @Generated
        public Buffering(byte[] body) {
            this.body = body;
        }
    }

    private static final class Offering
    implements State {
        private Offering() {
        }

        @Override
        public State without() {
            return new Unbuffered();
        }

        @Override
        public State buffer(org.apache.http.HttpResponse response) throws IOException {
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                return new Passing();
            }
            HttpEntities.Copy copy = HttpEntities.copy(entity);
            response.setEntity((HttpEntity)copy);
            return new Buffering(copy.getBody());
        }
    }
}

