/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.httpclient;

import java.io.IOException;
import lombok.Generated;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.httpclient.Attributes;
import org.zalando.logbook.httpclient.LocalRequest;

@API(status=API.Status.STABLE)
public final class LogbookHttpRequestInterceptor
implements HttpRequestInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogbookHttpRequestInterceptor.class);
    private final Logbook logbook;

    public LogbookHttpRequestInterceptor(Logbook logbook) {
        this.logbook = logbook;
    }

    public void process(org.apache.http.HttpRequest httpRequest, HttpContext context) throws IOException {
        try {
            LocalRequest request = new LocalRequest(httpRequest);
            Logbook.ResponseProcessingStage stage = this.logbook.process((HttpRequest)request).write();
            context.setAttribute(Attributes.STAGE, (Object)stage);
        }
        catch (Exception e) {
            log.warn("Unable to log request. Will skip the request & response logging step.", (Throwable)e);
        }
    }
}

