/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.httpclient5;

import java.io.IOException;
import lombok.Generated;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.httpclient5.Attributes;
import org.zalando.logbook.httpclient5.RemoteResponse;

@API(status=API.Status.EXPERIMENTAL)
public final class LogbookHttpResponseInterceptor
implements HttpResponseInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogbookHttpResponseInterceptor.class);

    public void process(org.apache.hc.core5.http.HttpResponse original, EntityDetails entity, HttpContext context) throws IOException {
        try {
            this.doProcess(original, context);
        }
        catch (Exception e) {
            log.warn("Unable to log response. Will skip the response logging step.", (Throwable)e);
        }
    }

    private void doProcess(org.apache.hc.core5.http.HttpResponse original, HttpContext context) throws IOException {
        Logbook.ResponseProcessingStage stage = this.find(context);
        if (stage != null) {
            stage.process((HttpResponse)new RemoteResponse(original)).write();
        } else {
            log.warn("Unable to log response: ResponseProcessingStage is null in HttpContext. Will skip the response logging step.");
        }
    }

    private Logbook.ResponseProcessingStage find(HttpContext context) {
        return (Logbook.ResponseProcessingStage)context.getAttribute(Attributes.STAGE);
    }
}

