/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.httpclient5;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ProtocolVersion;
import org.zalando.fauxpas.FauxPas;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Origin;
import org.zalando.logbook.httpclient5.ByteBufferUtils;
import org.zalando.logbook.httpclient5.HttpEntities;

final class RemoteResponse
implements HttpResponse {
    private final AtomicReference<State> state = new AtomicReference<Unbuffered>(new Unbuffered());
    private final org.apache.hc.core5.http.HttpResponse response;
    private final EntityDetails entityDetails;
    private final ByteBuffer body;

    RemoteResponse(org.apache.hc.core5.http.HttpResponse response) {
        this.response = response;
        this.body = null;
        this.entityDetails = null;
    }

    public Origin getOrigin() {
        return Origin.REMOTE;
    }

    public String getProtocolVersion() {
        ProtocolVersion version = this.response.getVersion();
        if (version != null) {
            return version.toString();
        }
        return HttpVersion.HTTP_1_1.toString();
    }

    public int getStatus() {
        return this.response.getCode();
    }

    public String getReasonPhrase() {
        return this.response.getReasonPhrase();
    }

    public HttpHeaders getHeaders() {
        HttpHeaders headers = HttpHeaders.empty();
        Set entries = Stream.of(this.response.getHeaders()).collect(Collectors.groupingBy(NameValuePair::getName, Collectors.mapping(NameValuePair::getValue, Collectors.toList()))).entrySet();
        for (Map.Entry entry : entries) {
            String name = entry.getKey();
            List values = entry.getValue();
            headers = headers.update(name, values);
        }
        return headers;
    }

    public String getContentType() {
        if (this.entityDetails != null) {
            return this.entityDetails.getContentType();
        }
        return Optional.of(this.response).map(response -> response.getFirstHeader("Content-Type")).map(NameValuePair::getValue).orElse("");
    }

    public Charset getCharset() {
        return Optional.of(this.response).map(response -> response.getFirstHeader("Content-Type")).map(NameValuePair::getValue).map(ContentType::parse).map(ContentType::getCharset).orElse(StandardCharsets.UTF_8);
    }

    public HttpResponse withBody() throws IOException {
        this.state.updateAndGet(State::with);
        return this;
    }

    public RemoteResponse withoutBody() {
        this.state.updateAndGet(State::without);
        return this;
    }

    public byte[] getBody() {
        return this.state.updateAndGet((UnaryOperator<State>)FauxPas.throwingUnaryOperator(state -> this.body != null ? state.buffer(Objects.requireNonNull(this.entityDetails), this.body) : state.buffer(this.response))).getBody();
    }

    @Generated
    public RemoteResponse(org.apache.hc.core5.http.HttpResponse response, EntityDetails entityDetails, ByteBuffer body) {
        this.response = response;
        this.entityDetails = entityDetails;
        this.body = body;
    }

    private static final class Unbuffered
    implements State {
        private Unbuffered() {
        }

        @Override
        public State with() {
            return new Offering();
        }
    }

    private static interface State {
        default public State with() {
            return this;
        }

        default public State without() {
            return this;
        }

        default public State buffer(org.apache.hc.core5.http.HttpResponse response) throws IOException {
            return this;
        }

        default public State buffer(EntityDetails entity, ByteBuffer body) {
            return this;
        }

        default public byte[] getBody() {
            return new byte[0];
        }
    }

    private static final class Passing
    implements State {
        private Passing() {
        }
    }

    private static final class Ignoring
    implements State {
        private final Buffering buffering;

        @Override
        public State with() {
            return this.buffering;
        }

        @Generated
        public Ignoring(Buffering buffering) {
            this.buffering = buffering;
        }
    }

    private static final class Buffering
    implements State {
        private final byte[] body;

        @Override
        public State without() {
            return new Ignoring(this);
        }

        @Override
        public byte[] getBody() {
            return this.body;
        }

        @Generated
        public Buffering(byte[] body) {
            this.body = body;
        }
    }

    private static final class Offering
    implements State {
        private Offering() {
        }

        @Override
        public State without() {
            return new Unbuffered();
        }

        @Override
        public State buffer(org.apache.hc.core5.http.HttpResponse response) throws IOException {
            if (response instanceof ClassicHttpResponse) {
                ClassicHttpResponse classicResponse = (ClassicHttpResponse)response;
                HttpEntity entity = classicResponse.getEntity();
                if (entity == null) {
                    return new Passing();
                }
                HttpEntities.Copy copy = HttpEntities.copy(entity);
                classicResponse.setEntity((HttpEntity)copy);
                return new Buffering(copy.getBody());
            }
            return new Passing();
        }

        @Override
        public State buffer(EntityDetails entityDetails, ByteBuffer body) {
            int contentLength = (int)entityDetails.getContentLength();
            if ((long)contentLength == -1L) {
                contentLength = body.remaining();
            }
            byte[] buffer = new byte[contentLength];
            ByteBufferUtils.fixedSizeCopy(body, buffer);
            return new Buffering(buffer);
        }
    }
}

