/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.httpclient5;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apiguardian.api.API;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.httpclient5.Attributes;
import org.zalando.logbook.httpclient5.ForwardingHttpAsyncResponseConsumer;
import org.zalando.logbook.httpclient5.RemoteResponse;

@API(status=API.Status.EXPERIMENTAL)
public final class LogbookHttpAsyncResponseConsumer<T>
extends ForwardingHttpAsyncResponseConsumer<T> {
    private final AsyncResponseConsumer<T> consumer;
    private org.apache.hc.core5.http.HttpResponse response;
    private EntityDetails entityDetails;
    private Logbook.ResponseProcessingStage stage;

    public LogbookHttpAsyncResponseConsumer(AsyncResponseConsumer<T> consumer) {
        this.consumer = consumer;
    }

    @Override
    protected AsyncResponseConsumer<T> delegate() {
        return this.consumer;
    }

    @Override
    public void consumeResponse(org.apache.hc.core5.http.HttpResponse response, EntityDetails entityDetails, HttpContext context, FutureCallback<T> resultCallback) throws HttpException, IOException {
        this.stage = this.find(context);
        if (entityDetails == null) {
            this.stage.process((HttpResponse)new RemoteResponse(response)).write();
        } else {
            this.response = response;
            this.entityDetails = entityDetails;
        }
        this.delegate().consumeResponse(response, entityDetails, context, resultCallback);
    }

    @Override
    public void consume(ByteBuffer src) throws IOException {
        this.stage.process((HttpResponse)new RemoteResponse(this.response, this.entityDetails, src)).write();
        this.delegate().consume(src);
    }

    private Logbook.ResponseProcessingStage find(HttpContext context) {
        return (Logbook.ResponseProcessingStage)context.getAttribute(Attributes.STAGE);
    }
}

