/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.httpclient5;

import java.io.IOException;
import lombok.Generated;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.httpclient5.Attributes;
import org.zalando.logbook.httpclient5.LocalRequest;

@API(status=API.Status.EXPERIMENTAL)
public final class LogbookHttpRequestInterceptor
implements HttpRequestInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogbookHttpRequestInterceptor.class);
    private final Logbook logbook;

    public LogbookHttpRequestInterceptor(Logbook logbook) {
        this.logbook = logbook;
    }

    public void process(org.apache.hc.core5.http.HttpRequest httpRequest, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        try {
            LocalRequest request = new LocalRequest(httpRequest, entity);
            Logbook.ResponseProcessingStage stage = this.logbook.process((HttpRequest)request).write();
            context.setAttribute(Attributes.STAGE, (Object)stage);
        }
        catch (Exception e) {
            log.warn("Unable to log request. Will skip the request & response logging step.", (Throwable)e);
        }
    }
}

