/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.httpclient5;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.nio.AsyncDataProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.zalando.fauxpas.FauxPas;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.Origin;
import org.zalando.logbook.httpclient5.BufferingFixedSizeDataStreamChannel;
import org.zalando.logbook.httpclient5.HttpEntities;

final class LocalRequest
implements HttpRequest {
    private final AtomicReference<State> state = new AtomicReference<Unbuffered>(new Unbuffered());
    private final org.apache.hc.core5.http.HttpRequest request;
    private final EntityDetails entity;
    private final URI originalRequestUri;

    LocalRequest(org.apache.hc.core5.http.HttpRequest request, EntityDetails entity) {
        this.request = request;
        this.originalRequestUri = request.getUri();
        this.entity = entity;
    }

    public Origin getOrigin() {
        return Origin.LOCAL;
    }

    public String getProtocolVersion() {
        ProtocolVersion version = this.request.getVersion();
        if (version != null) {
            return version.format();
        }
        return HttpVersion.HTTP_1_1.toString();
    }

    public String getRemote() {
        return "localhost";
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getScheme() {
        return this.originalRequestUri.getScheme();
    }

    public String getHost() {
        return this.originalRequestUri.getHost();
    }

    public Optional<Integer> getPort() {
        return Optional.of(this.originalRequestUri.getPort()).filter(p -> p != -1);
    }

    public String getPath() {
        return this.originalRequestUri.getPath();
    }

    public String getQuery() {
        return Optional.ofNullable(this.originalRequestUri.getQuery()).orElse("");
    }

    public HttpHeaders getHeaders() {
        HttpHeaders headers = HttpHeaders.empty();
        Set entries = Stream.of(this.request.getHeaders()).collect(Collectors.groupingBy(NameValuePair::getName, Collectors.mapping(NameValuePair::getValue, Collectors.toList()))).entrySet();
        for (Map.Entry entry : entries) {
            String name = entry.getKey();
            List values = entry.getValue();
            headers = headers.update(name, values);
        }
        return headers;
    }

    public String getContentType() {
        if (this.entity != null) {
            return this.entity.getContentType();
        }
        return Optional.of(this.request).map(request -> request.getFirstHeader("Content-Type")).map(NameValuePair::getValue).orElse("");
    }

    public Charset getCharset() {
        return Optional.of(this.request).map(request -> request.getFirstHeader("Content-Type")).map(NameValuePair::getValue).map(ContentType::parse).map(ContentType::getCharset).orElse(StandardCharsets.UTF_8);
    }

    public HttpRequest withBody() {
        this.state.updateAndGet(State::with);
        return this;
    }

    public HttpRequest withoutBody() {
        this.state.updateAndGet(State::without);
        return this;
    }

    public byte[] getBody() {
        return this.state.updateAndGet((UnaryOperator<State>)FauxPas.throwingUnaryOperator(state -> state.buffer(this.request, this.entity))).getBody();
    }

    private static final class Unbuffered
    implements State {
        private Unbuffered() {
        }

        @Override
        public State with() {
            return new Offering();
        }
    }

    private static interface State {
        default public State with() {
            return this;
        }

        default public State without() {
            return this;
        }

        default public State buffer(org.apache.hc.core5.http.HttpRequest request, EntityDetails entity) throws IOException {
            return this;
        }

        default public byte[] getBody() {
            return new byte[0];
        }
    }

    private static final class Passing
    implements State {
        private Passing() {
        }
    }

    private static final class Ignoring
    implements State {
        private final Buffering buffering;

        @Override
        public State with() {
            return this.buffering;
        }

        @Generated
        public Ignoring(Buffering buffering) {
            this.buffering = buffering;
        }
    }

    private static final class Buffering
    implements State {
        private final byte[] body;

        @Override
        public State without() {
            return new Ignoring(this);
        }

        @Override
        public byte[] getBody() {
            return this.body;
        }

        @Generated
        public Buffering(byte[] body) {
            this.body = body;
        }
    }

    private static final class Offering
    implements State {
        private Offering() {
        }

        @Override
        public State without() {
            return new Unbuffered();
        }

        @Override
        public State buffer(org.apache.hc.core5.http.HttpRequest request, EntityDetails entity) throws IOException {
            if (request instanceof ClassicHttpRequest) {
                ClassicHttpRequest original = (ClassicHttpRequest)request;
                HttpEntity httpEntity = original.getEntity();
                if (httpEntity == null) {
                    return new Passing();
                }
                HttpEntities.Copy copy = HttpEntities.copy(httpEntity);
                original.setEntity((HttpEntity)copy);
                return new Buffering(copy.getBody());
            }
            if (entity instanceof AsyncDataProducer) {
                int contentLength = (int)entity.getContentLength();
                byte[] body = new byte[contentLength];
                BufferingFixedSizeDataStreamChannel channel = new BufferingFixedSizeDataStreamChannel(body);
                ((AsyncDataProducer)entity).produce((DataStreamChannel)channel);
                return new Buffering(channel.getBuffer());
            }
            return new Passing();
        }
    }
}

