/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.jaxrs;

import jakarta.ws.rs.client.ClientResponseContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import lombok.Generated;
import org.zalando.fauxpas.FauxPas;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Origin;
import org.zalando.logbook.jaxrs.ByteStreams;
import org.zalando.logbook.jaxrs.HttpMessages;

final class RemoteResponse
implements HttpResponse {
    private final AtomicReference<State> state = new AtomicReference<Unbuffered>(new Unbuffered());
    private final ClientResponseContext context;

    public int getStatus() {
        return this.context.getStatus();
    }

    public String getProtocolVersion() {
        return "HTTP/1.1";
    }

    public Origin getOrigin() {
        return Origin.REMOTE;
    }

    public HttpHeaders getHeaders() {
        return HttpHeaders.of((Map)this.context.getHeaders());
    }

    @Nullable
    public String getContentType() {
        return Objects.toString(this.context.getMediaType(), null);
    }

    public Charset getCharset() {
        return HttpMessages.getCharset(this.context.getMediaType());
    }

    public HttpResponse withBody() {
        this.state.updateAndGet(State::with);
        return this;
    }

    public HttpResponse withoutBody() {
        this.state.updateAndGet(State::without);
        return this;
    }

    void expose() {
        this.state.updateAndGet((UnaryOperator<State>)FauxPas.throwingUnaryOperator(state -> state.buffer(this.context)));
    }

    public byte[] getBody() {
        return this.state.get().getBody();
    }

    @Generated
    public RemoteResponse(ClientResponseContext context) {
        this.context = context;
    }

    private static interface State {
        default public State with() {
            return this;
        }

        default public State without() {
            return this;
        }

        default public State buffer(ClientResponseContext context) throws IOException {
            return this;
        }

        default public byte[] getBody() {
            return new byte[0];
        }
    }

    private static final class Unbuffered
    implements State {
        private Unbuffered() {
        }

        @Override
        public State with() {
            return new Offering();
        }
    }

    private static final class Ignoring
    implements State {
        private final Buffering buffering;

        @Override
        public State with() {
            return this.buffering;
        }

        @Generated
        public Ignoring(Buffering buffering) {
            this.buffering = buffering;
        }
    }

    private static final class Buffering
    implements State {
        private final byte[] body;

        @Override
        public State without() {
            return new Ignoring(this);
        }

        @Override
        public byte[] getBody() {
            return this.body;
        }

        @Generated
        public Buffering(byte[] body) {
            this.body = body;
        }
    }

    private static final class Offering
    implements State {
        private Offering() {
        }

        @Override
        public State without() {
            return new Unbuffered();
        }

        @Override
        public State buffer(ClientResponseContext context) throws IOException {
            try (InputStream entityStream = context.getEntityStream();){
                byte[] body = ByteStreams.toByteArray(entityStream);
                context.setEntityStream((InputStream)new ByteArrayInputStream(body));
                Buffering buffering = new Buffering(body);
                return buffering;
            }
        }
    }
}

