/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.json;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.logbook.BodyFilter;
import org.zalando.logbook.json.JsonCompactor;
import org.zalando.logbook.json.JsonMediaType;
import org.zalando.logbook.json.ParsingJsonCompactor;

@API(status=API.Status.MAINTAINED)
public final class CompactingJsonBodyFilter
implements BodyFilter {
    private static final Logger log = LoggerFactory.getLogger(CompactingJsonBodyFilter.class);
    private final JsonCompactor compactor;

    public CompactingJsonBodyFilter(JsonCompactor compactor) {
        this.compactor = compactor;
    }

    public CompactingJsonBodyFilter() {
        this(new ParsingJsonCompactor());
    }

    public String filter(@Nullable String contentType, String body) {
        if (!JsonMediaType.JSON.test(contentType)) {
            return body;
        }
        try {
            return this.compactor.compact(body);
        }
        catch (IOException e) {
            log.trace("Unable to compact body, is it a JSON?. Keep it as-is: `{}`", (Object)e.getMessage());
            return body;
        }
    }
}

