/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.json;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.zalando.logbook.BodyFilter;
import org.zalando.logbook.json.PrimitiveJsonPropertyBodyFilter;

public final class JsonBodyFilters {
    private JsonBodyFilters() {
    }

    @API(status=API.Status.MAINTAINED)
    public static BodyFilter accessToken() {
        HashSet<String> properties = new HashSet<String>(Arrays.asList("access_token", "refresh_token", "open_id", "id_token"));
        return JsonBodyFilters.replaceJsonStringProperty(properties, "XXX");
    }

    @API(status=API.Status.MAINTAINED)
    public static BodyFilter replaceJsonStringProperty(Set<String> properties, String replacement) {
        return JsonBodyFilters.replaceJsonStringProperty(properties::contains, replacement);
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static BodyFilter replaceJsonStringProperty(Predicate<String> predicate, String replacement) {
        return PrimitiveJsonPropertyBodyFilter.replaceString(predicate, replacement);
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static BodyFilter replaceJsonNumberProperty(Set<String> properties, Number replacement) {
        Predicate<String> predicate = properties::contains;
        return JsonBodyFilters.replaceJsonNumberProperty(predicate, replacement);
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static BodyFilter replaceJsonNumberProperty(Predicate<String> predicate, Number replacement) {
        return PrimitiveJsonPropertyBodyFilter.replaceNumber(predicate, replacement);
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static BodyFilter replacePrimitiveJsonProperty(Predicate<String> predicate, String replacement) {
        return PrimitiveJsonPropertyBodyFilter.replacePrimitive(predicate, replacement);
    }
}

