/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apiguardian.api.API;
import org.zalando.logbook.BodyFilter;
import org.zalando.logbook.json.JsonMediaType;

@API(status=API.Status.EXPERIMENTAL)
public final class JsonPathBodyFilters {
    private static JsonPathBodyFilter filter(Operation operation) {
        return new JsonPathBodyFilter(operation);
    }

    public static JsonPathBodyFilterBuilder jsonPath(String jsonPath) {
        return new JsonPathBodyFilterBuilder(JsonPath.compile((String)jsonPath, (Predicate[])new Predicate[0]));
    }

    @Generated
    private JsonPathBodyFilters() {
    }

    private static final class CompositeOperation
    implements Operation {
        private final Collection<Operation> operations;

        @Override
        public DocumentContext filter(DocumentContext context) {
            DocumentContext result = context;
            for (Operation operation : this.operations) {
                result = operation.filter(result);
            }
            return result;
        }

        @Generated
        public CompositeOperation(Collection<Operation> operations) {
            this.operations = operations;
        }
    }

    @FunctionalInterface
    private static interface Operation {
        public DocumentContext filter(DocumentContext var1);

        public static Operation composite(Operation ... operations) {
            return Operation.composite(Arrays.asList(operations));
        }

        public static Operation composite(Collection<Operation> operations) {
            return new CompositeOperation(operations);
        }
    }

    private static class JsonPathBodyFilter
    implements BodyFilter {
        private static final ParseContext CONTEXT = JsonPath.using((Configuration)Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).mappingProvider((MappingProvider)new JacksonMappingProvider()).options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).build());
        private final Operation operation;

        public String filter(@Nullable String contentType, String body) {
            if (JsonMediaType.JSON.test(contentType)) {
                DocumentContext original = CONTEXT.parse(body);
                return this.operation.filter(original).jsonString();
            }
            return body;
        }

        @Nullable
        public BodyFilter tryMerge(BodyFilter next) {
            if (next instanceof JsonPathBodyFilter) {
                JsonPathBodyFilter filter = (JsonPathBodyFilter)next;
                return new JsonPathBodyFilter(Operation.composite(this.operation, filter.operation));
            }
            return super.tryMerge(next);
        }

        @Generated
        public JsonPathBodyFilter(Operation operation) {
            this.operation = operation;
        }
    }

    public static final class JsonPathBodyFilterBuilder {
        private final JsonPath path;

        public BodyFilter delete() {
            return JsonPathBodyFilters.filter(context -> context.delete(this.path));
        }

        public BodyFilter replace(String replacement) {
            return this.replace((JsonNode)new TextNode(replacement));
        }

        public BodyFilter replace(Boolean replacement) {
            return this.replace((JsonNode)BooleanNode.valueOf((boolean)replacement));
        }

        public BodyFilter replace(Double replacement) {
            return this.replace((JsonNode)new DoubleNode(replacement.doubleValue()));
        }

        public BodyFilter replace(JsonNode replacement) {
            return JsonPathBodyFilters.filter(context -> context.set(this.path, (Object)replacement));
        }

        public BodyFilter replace(Pattern pattern, String replacement) {
            return JsonPathBodyFilters.filter(context -> context.map(this.path, (node, config) -> {
                Matcher matcher = pattern.matcher(node.toString());
                if (matcher.find()) {
                    return new TextNode(matcher.replaceAll(replacement));
                }
                return node;
            }));
        }

        @Generated
        private JsonPathBodyFilterBuilder(JsonPath path) {
            this.path = path;
        }
    }
}

