/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.logstash;

import java.io.IOException;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.zalando.logbook.Correlation;
import org.zalando.logbook.HttpLogFormatter;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.Precorrelation;
import org.zalando.logbook.Sink;
import org.zalando.logbook.logstash.AutodetectPrettyPrintingMarker;

@API(status=API.Status.EXPERIMENTAL)
public final class LogstashLogbackSink
implements Sink {
    private static final Logger log = LoggerFactory.getLogger(Logbook.class);
    private final HttpLogFormatter formatter;

    public boolean isActive() {
        return log.isTraceEnabled();
    }

    public void write(Precorrelation precorrelation, HttpRequest request) throws IOException {
        AutodetectPrettyPrintingMarker marker = new AutodetectPrettyPrintingMarker("http", this.formatter.format(precorrelation, request));
        log.trace((Marker)marker, this.requestMessage(request));
    }

    private String requestMessage(HttpRequest request) {
        return request.getMethod() + " " + request.getRequestUri();
    }

    public void write(Correlation correlation, HttpRequest request, HttpResponse response) throws IOException {
        AutodetectPrettyPrintingMarker marker = new AutodetectPrettyPrintingMarker("http", this.formatter.format(correlation, response));
        log.trace((Marker)marker, this.responseMessage(request, response));
    }

    private String responseMessage(HttpRequest request, HttpResponse response) {
        String requestUri = request.getRequestUri();
        StringBuilder messageBuilder = new StringBuilder(64 + requestUri.length());
        messageBuilder.append(response.getStatus());
        String reasonPhrase = response.getReasonPhrase();
        if (reasonPhrase != null) {
            messageBuilder.append(' ');
            messageBuilder.append(reasonPhrase);
        }
        messageBuilder.append(' ');
        messageBuilder.append(request.getMethod());
        messageBuilder.append(' ');
        messageBuilder.append(requestUri);
        return messageBuilder.toString();
    }

    public LogstashLogbackSink(HttpLogFormatter formatter) {
        this.formatter = formatter;
    }
}

