/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import javax.annotation.concurrent.NotThreadSafe;
import lombok.Generated;
import org.apiguardian.api.API;
import org.zalando.fauxpas.FauxPas;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.Origin;
import org.zalando.logbook.netty.Conditionals;
import org.zalando.logbook.netty.Request;
import org.zalando.logbook.netty.Response;
import org.zalando.logbook.netty.Sequence;

@API(status=API.Status.EXPERIMENTAL)
@NotThreadSafe
public final class LogbookServerHandler
extends ChannelDuplexHandler {
    private final Sequence sequence = new Sequence(2);
    private final Logbook logbook;
    private Request request;
    private Response response;
    private Logbook.RequestWritingStage requestStage;
    private Logbook.ResponseWritingStage responseStage;

    public void channelRead(ChannelHandlerContext context, Object message) {
        Conditionals.runIf(message, io.netty.handler.codec.http.HttpRequest.class, httpRequest -> {
            this.request = new Request(context, Origin.REMOTE, (io.netty.handler.codec.http.HttpRequest)httpRequest);
            this.requestStage = this.logbook.process((HttpRequest)this.request);
        });
        Conditionals.runIf(message, HttpContent.class, content -> this.request.buffer(content.content()));
        Conditionals.runIf(message, ByteBuf.class, this.request::buffer);
        Conditionals.runIf(message, LastHttpContent.class, content -> this.sequence.set(0, (Runnable)FauxPas.throwingRunnable(() -> ((Logbook.RequestWritingStage)this.requestStage).write())));
        context.fireChannelRead(message);
    }

    public void write(ChannelHandlerContext context, Object message, ChannelPromise promise) {
        Conditionals.runIf(message, io.netty.handler.codec.http.HttpResponse.class, httpResponse -> {
            this.response = new Response(Origin.LOCAL, (io.netty.handler.codec.http.HttpResponse)httpResponse);
            this.responseStage = this.requestStage.process((HttpResponse)this.response);
        });
        Conditionals.runIf(message, HttpContent.class, content -> this.response.buffer(content.content()));
        Conditionals.runIf(message, ByteBuf.class, this.response::buffer);
        Conditionals.runIf(message, LastHttpContent.class, content -> this.sequence.set(1, (Runnable)FauxPas.throwingRunnable(() -> ((Logbook.ResponseWritingStage)this.responseStage).write())));
        context.write(message, promise);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (this.sequence.hasSecondTask()) {
            this.sequence.set(0, (Runnable)FauxPas.throwingRunnable(() -> ((Logbook.RequestWritingStage)this.requestStage).write()));
        }
        super.handlerRemoved(ctx);
    }

    @Generated
    public LogbookServerHandler(Logbook logbook) {
        this.logbook = logbook;
    }
}

