/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.okhttp;

import java.io.IOException;
import java.util.Optional;
import okhttp3.Interceptor;
import okhttp3.Response;
import org.apiguardian.api.API;
import org.zalando.logbook.Correlator;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.RawHttpRequest;
import org.zalando.logbook.RawHttpResponse;
import org.zalando.logbook.okhttp.LocalRequest;
import org.zalando.logbook.okhttp.RemoteResponse;

@API(status=API.Status.EXPERIMENTAL)
public final class LogbookInterceptor
implements Interceptor {
    private final Logbook logbook;

    public LogbookInterceptor(Logbook logbook) {
        this.logbook = logbook;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        LocalRequest request = new LocalRequest(chain.request());
        Optional correlator = this.logbook.write((RawHttpRequest)request);
        RemoteResponse response = new RemoteResponse(chain.proceed(request.toRequest()));
        if (correlator.isPresent()) {
            ((Correlator)correlator.get()).write((RawHttpResponse)response);
        }
        return response.toResponse();
    }
}

