/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.okhttp;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.Origin;

final class LocalRequest
implements HttpRequest {
    private Request request;
    @Nullable
    private byte[] body;

    LocalRequest(Request request) {
        this.request = request;
    }

    public String getRemote() {
        return "localhost";
    }

    public String getMethod() {
        return this.request.method();
    }

    public String getScheme() {
        return this.request.url().scheme();
    }

    public String getHost() {
        return this.request.url().host();
    }

    public Optional<Integer> getPort() {
        int defaultPort;
        int port = this.request.url().port();
        return port == (defaultPort = HttpUrl.defaultPort((String)this.request.url().scheme())) ? Optional.empty() : Optional.of(port);
    }

    public String getPath() {
        return this.request.url().encodedPath();
    }

    public String getQuery() {
        return Optional.ofNullable(this.request.url().query()).orElse("");
    }

    public String getProtocolVersion() {
        return "HTTP/1.1";
    }

    public Origin getOrigin() {
        return Origin.LOCAL;
    }

    public Map<String, List<String>> getHeaders() {
        return this.request.headers().toMultimap();
    }

    public String getContentType() {
        return this.contentType().map(MediaType::toString).orElse("");
    }

    public Charset getCharset() {
        return this.contentType().map(MediaType::charset).orElse(StandardCharsets.UTF_8);
    }

    private Optional<MediaType> contentType() {
        return Optional.ofNullable(this.request.body()).map(RequestBody::contentType);
    }

    public HttpRequest withBody() throws IOException {
        if (this.body == null) {
            RequestBody entity = this.request.body();
            if (entity == null) {
                return this.withoutBody();
            }
            this.body = LocalRequest.bytes(entity);
            this.request = this.request.newBuilder().method(this.request.method(), RequestBody.create((MediaType)entity.contentType(), (byte[])this.body)).build();
        }
        return this;
    }

    public HttpRequest withoutBody() {
        this.body = new byte[0];
        return this;
    }

    private static byte[] bytes(RequestBody body) throws IOException {
        Buffer buffer = new Buffer();
        body.writeTo((BufferedSink)buffer);
        return buffer.readByteArray();
    }

    Request toRequest() {
        return this.request;
    }

    public byte[] getBody() {
        return this.body == null ? new byte[]{} : this.body;
    }
}

