/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.okhttp;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import okhttp3.MediaType;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Origin;

final class RemoteResponse
implements HttpResponse {
    private Response response;
    @Nullable
    private byte[] body;

    RemoteResponse(Response response) {
        this.response = response;
    }

    public int getStatus() {
        return this.response.code();
    }

    public String getProtocolVersion() {
        return this.response.protocol().toString().toUpperCase(Locale.ROOT);
    }

    public Origin getOrigin() {
        return Origin.REMOTE;
    }

    public Map<String, List<String>> getHeaders() {
        return this.response.headers().toMultimap();
    }

    public String getContentType() {
        return this.contentType().map(MediaType::toString).orElse("");
    }

    public Charset getCharset() {
        return this.contentType().map(MediaType::charset).orElse(StandardCharsets.UTF_8);
    }

    private Optional<MediaType> contentType() {
        return Optional.ofNullable(this.response.body()).map(ResponseBody::contentType);
    }

    public HttpResponse withBody() throws IOException {
        if (this.body == null) {
            ResponseBody entity = Objects.requireNonNull(this.response.body(), "Body is never null for normal responses");
            if (entity.contentLength() == 0L) {
                return this.withoutBody();
            }
            this.body = entity.bytes();
            this.response = this.response.newBuilder().body(ResponseBody.create((MediaType)entity.contentType(), (byte[])this.body)).build();
        }
        return this;
    }

    public RemoteResponse withoutBody() {
        this.body = new byte[0];
        return this;
    }

    Response toResponse() {
        return this.response;
    }

    public byte[] getBody() {
        return this.body == null ? new byte[]{} : this.body;
    }
}

