/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.okhttp;

import java.io.IOException;
import javax.annotation.Nonnull;
import okhttp3.Interceptor;
import okhttp3.Response;
import org.apiguardian.api.API;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.okhttp.LocalRequest;
import org.zalando.logbook.okhttp.RemoteResponse;

@API(status=API.Status.EXPERIMENTAL)
public final class LogbookInterceptor
implements Interceptor {
    private final Logbook logbook;

    public LogbookInterceptor(Logbook logbook) {
        this.logbook = logbook;
    }

    @Nonnull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        LocalRequest request = new LocalRequest(chain.request());
        Logbook.ResponseProcessingStage stage = this.logbook.process((HttpRequest)request).write();
        RemoteResponse response = new RemoteResponse(chain.proceed(request.toRequest()));
        stage.process((HttpResponse)response).write();
        return response.toResponse();
    }
}

