/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.okhttp;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import okhttp3.MediaType;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.zalando.fauxpas.FauxPas;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Origin;

final class RemoteResponse
implements HttpResponse {
    private final AtomicReference<State> state = new AtomicReference<Unbuffered>(new Unbuffered());
    private final Response response;

    public int getStatus() {
        return this.response.code();
    }

    public String getProtocolVersion() {
        return this.response.protocol().toString().toUpperCase(Locale.ROOT);
    }

    public Origin getOrigin() {
        return Origin.REMOTE;
    }

    public Map<String, List<String>> getHeaders() {
        return this.response.headers().toMultimap();
    }

    public String getContentType() {
        return this.contentType().map(MediaType::toString).orElse("");
    }

    public Charset getCharset() {
        return this.contentType().map(MediaType::charset).orElse(StandardCharsets.UTF_8);
    }

    private Optional<MediaType> contentType() {
        return Optional.ofNullable(this.response.body()).map(ResponseBody::contentType);
    }

    public HttpResponse withBody() {
        this.state.updateAndGet(State::with);
        return this;
    }

    public RemoteResponse withoutBody() {
        this.state.updateAndGet(State::without);
        return this;
    }

    Response toResponse() {
        return this.buffer().getResponse();
    }

    public byte[] getBody() {
        return this.buffer().getBody();
    }

    private State buffer() {
        return this.state.updateAndGet((UnaryOperator<State>)FauxPas.throwingUnaryOperator(State::buffer));
    }

    public RemoteResponse(Response response) {
        this.response = response;
    }

    private final class Passing
    extends AbstractState {
        private Passing() {
        }
    }

    private static final class Ignoring
    implements State {
        private final Response response;
        private final byte[] body;

        @Override
        public State with() {
            return new Buffering(this.response, this.body);
        }

        public Ignoring(Response response, byte[] body) {
            this.response = response;
            this.body = body;
        }

        @Override
        public Response getResponse() {
            return this.response;
        }
    }

    private static final class Buffering
    implements State {
        private final Response response;
        private final byte[] body;

        @Override
        public State without() {
            return new Ignoring(this.response, this.body);
        }

        @Override
        public byte[] getBody() {
            return this.body;
        }

        public Buffering(Response response, byte[] body) {
            this.response = response;
            this.body = body;
        }

        @Override
        public Response getResponse() {
            return this.response;
        }
    }

    private final class Offering
    extends AbstractState {
        private Offering() {
        }

        @Override
        public State without() {
            return new Unbuffered();
        }

        @Override
        public State buffer() throws IOException {
            ResponseBody entity = Objects.requireNonNull(RemoteResponse.this.response.body(), "Body is never null for normal responses");
            if (entity.contentLength() == 0L) {
                return new Passing();
            }
            byte[] body = entity.bytes();
            Response copy = RemoteResponse.this.response.newBuilder().body(ResponseBody.create((byte[])body, (MediaType)entity.contentType())).build();
            return new Buffering(copy, body);
        }
    }

    private final class Unbuffered
    extends AbstractState {
        private Unbuffered() {
        }

        @Override
        public State with() {
            return new Offering();
        }
    }

    private abstract class AbstractState
    implements State {
        private AbstractState() {
        }

        @Override
        public Response getResponse() {
            return RemoteResponse.this.response;
        }
    }

    private static interface State {
        default public State with() {
            return this;
        }

        default public State without() {
            return this;
        }

        default public State buffer() throws IOException {
            return this;
        }

        public Response getResponse();

        default public byte[] getBody() {
            return new byte[0];
        }
    }
}

