/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.okhttp2;

import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Origin;
import org.zalando.logbook.RawHttpResponse;

final class RemoteResponse
implements RawHttpResponse,
HttpResponse {
    private Response response;
    private byte[] body;

    public RemoteResponse(Response response) {
        this.response = response;
    }

    public int getStatus() {
        return this.response.code();
    }

    public String getProtocolVersion() {
        return this.response.protocol().toString().toUpperCase(Locale.ROOT);
    }

    public Origin getOrigin() {
        return Origin.REMOTE;
    }

    public Map<String, List<String>> getHeaders() {
        return this.response.headers().toMultimap();
    }

    public String getContentType() {
        return this.contentType().map(MediaType::toString).orElse("");
    }

    public Charset getCharset() {
        return this.contentType().map(MediaType::charset).orElse(StandardCharsets.UTF_8);
    }

    private Optional<MediaType> contentType() {
        return Optional.ofNullable(this.response.body()).map(ResponseBody::contentType);
    }

    public HttpResponse withBody() throws IOException {
        ResponseBody body = Objects.requireNonNull(this.response.body(), "Body is never null for normal responses");
        if (RemoteResponse.canSkipBody(this.response)) {
            this.body = new byte[0];
        } else {
            byte[] bytes = body.bytes();
            this.response = this.response.newBuilder().body(ResponseBody.create((MediaType)body.contentType(), (byte[])bytes)).build();
            this.body = bytes;
        }
        return this;
    }

    static boolean canSkipBody(Response response) {
        if ("HEAD".equals(response.request().method())) {
            return true;
        }
        return response.code() == 204 || response.code() == 304;
    }

    public Response toResponse() {
        return this.response;
    }

    public byte[] getBody() {
        return this.body;
    }
}

