/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.okhttp2;

import com.squareup.okhttp.Headers;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.squareup.okhttp.internal.http.RealResponseBody;
import java.io.IOException;
import java.util.Objects;
import okio.GzipSource;
import okio.Okio;
import okio.Source;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL)
public final class GzipInterceptor
implements Interceptor {
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response = chain.proceed(chain.request());
        if (this.isContentEncodingGzip(response)) {
            Headers headers = response.headers().newBuilder().removeAll("Content-Encoding").removeAll("Content-Length").build();
            return response.newBuilder().headers(headers).body((ResponseBody)new RealResponseBody(headers, Okio.buffer((Source)new GzipSource((Source)Objects.requireNonNull(response.body(), "body").source())))).build();
        }
        return response;
    }

    private boolean isContentEncodingGzip(Response response) {
        return "gzip".equalsIgnoreCase(response.header("Content-Encoding"));
    }
}

