/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.okhttp2;

import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import java.io.IOException;
import lombok.Generated;
import org.apiguardian.api.API;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.okhttp2.LocalRequest;
import org.zalando.logbook.okhttp2.RemoteResponse;

@API(status=API.Status.EXPERIMENTAL)
public final class LogbookInterceptor
implements Interceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogbookInterceptor.class);
    private final Logbook logbook;

    public Response intercept(Interceptor.Chain chain) throws IOException {
        LocalRequest request = new LocalRequest(chain.request());
        Logbook.ResponseProcessingStage stage = this.logRequest(request);
        RemoteResponse response = new RemoteResponse(chain.proceed(request.toRequest()));
        LogbookInterceptor.logResponse(stage, response);
        return response.toResponse();
    }

    @Nullable
    private Logbook.ResponseProcessingStage logRequest(LocalRequest request) {
        Logbook.ResponseProcessingStage stage = null;
        try {
            stage = this.logbook.process((HttpRequest)request).write();
        }
        catch (Exception e) {
            log.warn("Unable to log request. Will skip the request & response logging step.", (Throwable)e);
        }
        return stage;
    }

    private static void logResponse(@Nullable Logbook.ResponseProcessingStage stage, RemoteResponse response) {
        if (stage != null) {
            try {
                stage.process((HttpResponse)response).write();
            }
            catch (Exception e) {
                log.warn("Unable to log response. Will skip the response logging step.", (Throwable)e);
            }
        } else {
            log.warn("Unable to log response: ResponseProcessingStage is null. Will skip the response logging step.");
        }
    }

    @Generated
    public LogbookInterceptor(Logbook logbook) {
        this.logbook = logbook;
    }
}

