/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.openfeign;

import feign.Request;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import lombok.Generated;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.Origin;
import org.zalando.logbook.openfeign.HeaderUtils;

final class LocalRequest
implements HttpRequest {
    private final URI uri;
    private final Request.HttpMethod httpMethod;
    private final HttpHeaders headers;
    private final byte[] body;
    private final Charset charset;
    private boolean withBody = false;

    public static LocalRequest create(Request request) {
        return new LocalRequest(URI.create(request.url()), request.httpMethod(), HeaderUtils.toLogbookHeaders(request.headers()), request.body(), request.charset());
    }

    public String getRemote() {
        return "localhost";
    }

    public String getMethod() {
        return this.httpMethod.toString();
    }

    public String getScheme() {
        return this.uri.getScheme() == null ? "" : this.uri.getScheme();
    }

    public String getHost() {
        return this.uri.getHost() == null ? "" : this.uri.getHost();
    }

    public Optional<Integer> getPort() {
        return Optional.of(this.uri).map(URI::getPort).filter(p -> p != -1);
    }

    public String getPath() {
        return this.uri.getPath() == null ? "" : this.uri.getPath();
    }

    public String getQuery() {
        return this.uri.getQuery() == null ? "" : this.uri.getQuery();
    }

    public HttpRequest withBody() {
        this.withBody = true;
        return this;
    }

    public HttpRequest withoutBody() {
        this.withBody = false;
        return this;
    }

    public String getProtocolVersion() {
        return "HTTP/1.1";
    }

    public Origin getOrigin() {
        return Origin.LOCAL;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Nullable
    public String getContentType() {
        return Optional.ofNullable((List)this.headers.get((Object)"Content-Type")).flatMap(ct -> ct.stream().findFirst()).orElse(null);
    }

    public Charset getCharset() {
        return this.charset == null ? StandardCharsets.UTF_8 : this.charset;
    }

    public byte[] getBody() {
        return this.withBody && this.body != null ? this.body : new byte[]{};
    }

    @Generated
    public LocalRequest(URI uri, Request.HttpMethod httpMethod, HttpHeaders headers, byte[] body, Charset charset) {
        this.uri = uri;
        this.httpMethod = httpMethod;
        this.headers = headers;
        this.body = body;
        this.charset = charset;
    }
}

