/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.servlet;

import java.io.IOException;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zalando.logbook.Correlator;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.RawHttpRequest;
import org.zalando.logbook.RawHttpResponse;
import org.zalando.logbook.RawRequestFilter;
import org.zalando.logbook.servlet.Attributes;
import org.zalando.logbook.servlet.LocalResponse;
import org.zalando.logbook.servlet.RemoteRequest;
import org.zalando.logbook.servlet.Strategy;

final class SecurityStrategy
implements Strategy {
    private final RawRequestFilter filter;

    SecurityStrategy(RawRequestFilter filter) {
        this.filter = filter;
    }

    @Override
    public void doFilter(Logbook logbook, HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain chain) throws ServletException, IOException {
        Optional correlator;
        RemoteRequest request = new RemoteRequest(httpRequest);
        String protocolVersion = request.getProtocolVersion();
        LocalResponse response = new LocalResponse(httpResponse, protocolVersion);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
        if (this.isUnauthorized((HttpServletResponse)response) && (correlator = this.isFirstRequest((HttpServletRequest)request) ? logbook.write(this.filter.filter((RawHttpRequest)request)) : this.readCorrelator(request)).isPresent()) {
            ((Correlator)correlator.get()).write((RawHttpResponse)response);
        }
    }

    private boolean isUnauthorized(HttpServletResponse response) {
        return response.getStatus() == 401;
    }

    private Optional<Correlator> readCorrelator(RemoteRequest request) {
        return Optional.ofNullable(request.getAttribute(Attributes.CORRELATOR)).map(Correlator.class::cast);
    }
}

