/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.zalando.logbook.BaseHttpMessage;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Origin;
import org.zalando.logbook.RawHttpResponse;

final class LocalResponse
extends HttpServletResponseWrapper
implements RawHttpResponse,
HttpResponse {
    private final String protocolVersion;
    private boolean withBody;
    private Tee tee;

    LocalResponse(HttpServletResponse response, String protocolVersion) {
        super(response);
        this.protocolVersion = protocolVersion;
        this.withBody = true;
    }

    public Origin getOrigin() {
        return Origin.LOCAL;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public Map<String, List<String>> getHeaders() {
        BaseHttpMessage.HeadersBuilder builder = new BaseHttpMessage.HeadersBuilder();
        for (String header : this.getHeaderNames()) {
            builder.put(header, (Iterable)this.getHeaders(header));
        }
        return builder.build();
    }

    public Charset getCharset() {
        return Optional.ofNullable(this.getCharacterEncoding()).map(Charset::forName).orElse(StandardCharsets.UTF_8);
    }

    public HttpResponse withBody() {
        this.assertWithBody();
        return this;
    }

    public void withoutBody() {
        this.assertWithBody();
        this.withBody = false;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.withBody) {
            return this.tee().getOutputStream();
        }
        return super.getOutputStream();
    }

    public PrintWriter getWriter() throws IOException {
        if (this.withBody) {
            return this.tee().getWriter(this::getCharset);
        }
        return super.getWriter();
    }

    public byte[] getBody() throws IOException {
        this.assertWithBody();
        return this.tee().getBytes();
    }

    private void assertWithBody() {
        if (!this.withBody) {
            throw new IllegalStateException("Response is without body");
        }
    }

    private Tee tee() throws IOException {
        if (this.tee == null) {
            this.tee = new Tee((OutputStream)super.getOutputStream());
        }
        return this.tee;
    }

    private static class TeeServletOutputStream
    extends ServletOutputStream {
        private final OutputStream original;
        private final OutputStream branch;

        private TeeServletOutputStream(OutputStream original, OutputStream branch) {
            this.original = original;
            this.branch = branch;
        }

        public void write(int b) throws IOException {
            this.original.write(b);
            this.branch.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.original.write(b, off, len);
            this.branch.write(b, off, len);
        }

        public void flush() throws IOException {
            this.original.flush();
            this.branch.flush();
        }

        public void close() throws IOException {
            this.original.close();
            this.branch.close();
        }
    }

    private static class Tee {
        private final ByteArrayOutputStream branch = new ByteArrayOutputStream();
        private final TeeServletOutputStream output;
        private PrintWriter writer;
        private byte[] bytes;

        private Tee(OutputStream original) {
            this.output = new TeeServletOutputStream(original, this.branch);
        }

        ServletOutputStream getOutputStream() {
            return this.output;
        }

        PrintWriter getWriter(Supplier<Charset> charset) {
            if (this.writer == null) {
                this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this.output), charset.get()));
            }
            return this.writer;
        }

        byte[] getBytes() {
            if (this.bytes == null || this.bytes.length != this.branch.size()) {
                this.bytes = this.branch.toByteArray();
            }
            return this.bytes;
        }
    }
}

