/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.zalando.logbook.Headers;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Origin;

final class LocalResponse
extends HttpServletResponseWrapper
implements HttpResponse {
    private final String protocolVersion;
    private Tee body;
    private Tee buffer;
    private boolean used;

    LocalResponse(HttpServletResponse response, String protocolVersion) {
        super(response);
        this.protocolVersion = protocolVersion;
    }

    public Origin getOrigin() {
        return Origin.LOCAL;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public Map<String, List<String>> getHeaders() {
        Map headers = Headers.empty();
        for (String header : this.getHeaderNames()) {
            headers.put(header, new ArrayList(this.getHeaders(header)));
        }
        return headers;
    }

    public Charset getCharset() {
        return Optional.ofNullable(this.getCharacterEncoding()).map(Charset::forName).orElse(StandardCharsets.UTF_8);
    }

    public HttpResponse withBody() throws IOException {
        if (this.body == null) {
            this.bufferIfNecessary();
            this.body = this.buffer;
        }
        return this;
    }

    private void bufferIfNecessary() throws IOException {
        if (this.buffer == null) {
            this.buffer = new Tee(super.getOutputStream());
        }
    }

    public HttpResponse withoutBody() {
        this.body = null;
        if (!this.used) {
            this.buffer = null;
        }
        return this;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.buffer == null) {
            return super.getOutputStream();
        }
        this.used = true;
        return this.buffer.getOutputStream();
    }

    public PrintWriter getWriter() throws IOException {
        if (this.buffer == null) {
            return super.getWriter();
        }
        this.used = true;
        return this.buffer.getWriter(this::getCharset);
    }

    public byte[] getBody() {
        return this.body == null ? new byte[]{} : this.body.getBytes();
    }

    private static class TeeServletOutputStream
    extends ServletOutputStream {
        private final ServletOutputStream original;
        private final OutputStream branch;

        public void write(int b) throws IOException {
            this.original.write(b);
            this.branch.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.original.write(b, off, len);
            this.branch.write(b, off, len);
        }

        public void flush() throws IOException {
            this.original.flush();
            this.branch.flush();
        }

        public void close() throws IOException {
            this.original.close();
            this.branch.close();
        }

        public boolean isReady() {
            return this.original.isReady();
        }

        public void setWriteListener(WriteListener listener) {
            this.original.setWriteListener(listener);
        }

        public TeeServletOutputStream(ServletOutputStream original, OutputStream branch) {
            this.original = original;
            this.branch = branch;
        }
    }

    private static class Tee {
        private final ByteArrayOutputStream branch = new ByteArrayOutputStream();
        private final TeeServletOutputStream output;
        private PrintWriter writer;
        private byte[] bytes;

        private Tee(ServletOutputStream original) {
            this.output = new TeeServletOutputStream(original, this.branch);
        }

        ServletOutputStream getOutputStream() {
            return this.output;
        }

        PrintWriter getWriter(Supplier<Charset> charset) {
            if (this.writer == null) {
                this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this.output), charset.get()));
            }
            return this.writer;
        }

        byte[] getBytes() {
            if (this.bytes == null) {
                this.bytes = this.branch.toByteArray();
            }
            return this.bytes;
        }
    }
}

