/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.servlet;

import java.io.IOException;
import javax.annotation.Nullable;
import javax.servlet.DispatcherType;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apiguardian.api.API;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.Strategy;
import org.zalando.logbook.servlet.HttpFilter;
import org.zalando.logbook.servlet.LocalResponse;
import org.zalando.logbook.servlet.RemoteRequest;

@API(status=API.Status.STABLE)
public final class LogbookFilter
implements HttpFilter {
    private static final String STAGE = Logbook.ResponseProcessingStage.class.getName();
    private final Logbook logbook;
    private final Strategy strategy;

    public LogbookFilter() {
        this(Logbook.create());
    }

    public LogbookFilter(Logbook logbook) {
        this(logbook, null);
    }

    public LogbookFilter(Logbook logbook, @Nullable Strategy strategy) {
        this.logbook = logbook;
        this.strategy = strategy;
    }

    @Override
    public void doFilter(HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain chain) throws ServletException, IOException {
        RemoteRequest request = new RemoteRequest(httpRequest);
        LocalResponse response = new LocalResponse(httpResponse, request.getProtocolVersion());
        Logbook.ResponseWritingStage stage = this.logRequest((HttpServletRequest)request, request).process((HttpResponse)response);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
        if (request.isAsyncStarted()) {
            return;
        }
        response.flushBuffer();
        stage.write();
    }

    private Logbook.ResponseProcessingStage logRequest(HttpServletRequest httpRequest, HttpRequest request) throws IOException {
        if (httpRequest.getDispatcherType() == DispatcherType.ASYNC) {
            return (Logbook.ResponseProcessingStage)httpRequest.getAttribute(STAGE);
        }
        Logbook.ResponseProcessingStage stage = this.process(request).write();
        httpRequest.setAttribute(STAGE, (Object)stage);
        return stage;
    }

    private Logbook.RequestWritingStage process(HttpRequest request) throws IOException {
        return this.strategy == null ? this.logbook.process(request) : this.logbook.process(request, this.strategy);
    }
}

