/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.servlet;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.activation.MimeType;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.zalando.logbook.Headers;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.Origin;
import org.zalando.logbook.servlet.ByteStreams;
import org.zalando.logbook.servlet.FormRequestMode;
import org.zalando.logbook.servlet.MimeTypes;
import org.zalando.logbook.servlet.ServletInputStreamAdapter;

final class RemoteRequest
extends HttpServletRequestWrapper
implements HttpRequest {
    private final FormRequestMode formRequestMode = FormRequestMode.fromProperties();
    private byte[] body;
    private byte[] buffered;

    RemoteRequest(HttpServletRequest request) {
        super(request);
    }

    public String getProtocolVersion() {
        return this.getProtocol();
    }

    public Origin getOrigin() {
        return Origin.REMOTE;
    }

    public String getRemote() {
        return this.getRemoteAddr();
    }

    public String getHost() {
        return this.getServerName();
    }

    public Optional<Integer> getPort() {
        return Optional.of(this.getServerPort());
    }

    public String getPath() {
        return this.getRequestURI();
    }

    public String getQuery() {
        return Optional.ofNullable(this.getQueryString()).orElse("");
    }

    public Map<String, List<String>> getHeaders() {
        Map headers = Headers.empty();
        Enumeration names = this.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            headers.put(name, Collections.list(this.getHeaders(name)));
        }
        return headers;
    }

    public Charset getCharset() {
        return Optional.ofNullable(this.getCharacterEncoding()).map(Charset::forName).orElse(StandardCharsets.UTF_8);
    }

    public HttpRequest withBody() throws IOException {
        if (this.body == null) {
            this.bufferIfNecessary();
            this.body = this.buffered;
        }
        return this;
    }

    private void bufferIfNecessary() throws IOException {
        if (this.buffered == null) {
            if (this.isFormRequest()) {
                switch (this.formRequestMode) {
                    case PARAMETER: {
                        this.buffered = this.reconstructBodyFromParameters();
                        return;
                    }
                    case OFF: {
                        this.buffered = new byte[0];
                        return;
                    }
                }
            }
            this.buffered = ByteStreams.toByteArray((InputStream)super.getInputStream());
        }
    }

    public HttpRequest withoutBody() {
        this.body = null;
        return this;
    }

    private boolean isFormRequest() {
        return Optional.ofNullable(this.getContentType()).flatMap(MimeTypes::parse).filter(this::isFormRequest).isPresent();
    }

    private boolean isFormRequest(MimeType contentType) {
        return "application".equals(contentType.getPrimaryType()) && "x-www-form-urlencoded".equals(contentType.getSubType());
    }

    private byte[] reconstructBodyFromParameters() {
        return this.getParameterMap().entrySet().stream().flatMap(entry -> Arrays.stream((Object[])entry.getValue()).map(value -> RemoteRequest.encode((String)entry.getKey()) + "=" + RemoteRequest.encode(value))).collect(Collectors.joining("&")).getBytes(StandardCharsets.UTF_8);
    }

    private static String encode(String s) {
        return RemoteRequest.encode(s, "UTF-8");
    }

    static String encode(String s, String charset) {
        return URLEncoder.encode(s, charset);
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.buffered == null ? super.getInputStream() : new ServletInputStreamAdapter(new ByteArrayInputStream(this.buffered));
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), this.getCharset()));
    }

    public byte[] getBody() {
        return this.body == null ? new byte[]{} : this.body;
    }
}

