/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.servlet;

import java.io.IOException;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.servlet.DispatcherType;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apiguardian.api.API;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.Strategy;
import org.zalando.logbook.servlet.HttpFilter;
import org.zalando.logbook.servlet.LocalResponse;
import org.zalando.logbook.servlet.RemoteRequest;

@API(status=API.Status.STABLE)
public final class LogbookFilter
implements HttpFilter {
    private final String name = Logbook.ResponseProcessingStage.class.getName() + "-" + UUID.randomUUID();
    private final Logbook logbook;
    private final Strategy strategy;

    public LogbookFilter() {
        this(Logbook.create());
    }

    public LogbookFilter(Logbook logbook) {
        this(logbook, null);
    }

    public LogbookFilter(Logbook logbook, @Nullable Strategy strategy) {
        this.logbook = logbook;
        this.strategy = strategy;
    }

    @Override
    public void doFilter(HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain chain) throws ServletException, IOException {
        Logbook.ResponseProcessingStage processing;
        RemoteRequest request = new RemoteRequest(httpRequest);
        LocalResponse response = new LocalResponse(httpResponse, request.getProtocolVersion());
        if (request.getDispatcherType() == DispatcherType.ASYNC) {
            processing = (Logbook.ResponseProcessingStage)request.getAttribute(this.name);
        } else {
            processing = this.process(request).write();
            request.setAttribute(this.name, processing);
        }
        Logbook.ResponseWritingStage writing = processing.process((HttpResponse)response);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
        if (request.isAsyncStarted()) {
            return;
        }
        response.flushBuffer();
        writing.write();
    }

    private Logbook.RequestWritingStage process(HttpRequest request) throws IOException {
        return this.strategy == null ? this.logbook.process(request) : this.logbook.process(request, this.strategy);
    }
}

