/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.servlet.javax;

import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.servlet.DispatcherType;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apiguardian.api.API;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.Strategy;
import org.zalando.logbook.servlet.javax.FormRequestMode;
import org.zalando.logbook.servlet.javax.HttpFilter;
import org.zalando.logbook.servlet.javax.LocalResponse;
import org.zalando.logbook.servlet.javax.LogbookAsyncListener;
import org.zalando.logbook.servlet.javax.RemoteRequest;

@API(status=API.Status.STABLE)
public final class LogbookFilter
implements HttpFilter {
    private final String responseProcessingStageName = Logbook.ResponseProcessingStage.class.getName() + "-" + UUID.randomUUID();
    private final String responseWritingStageSynchronizationName = Logbook.ResponseWritingStage.class.getName() + "-Synchronization-" + UUID.randomUUID();
    private final Logbook logbook;
    private final Strategy strategy;
    private final FormRequestMode formRequestMode;

    public LogbookFilter() {
        this(Logbook.create());
    }

    public LogbookFilter(Logbook logbook) {
        this(logbook, null);
    }

    public LogbookFilter(Logbook logbook, @Nullable Strategy strategy) {
        this(logbook, strategy, FormRequestMode.fromProperties());
    }

    @Override
    public void doFilter(HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain chain) throws ServletException, IOException {
        Logbook.ResponseProcessingStage processing;
        RemoteRequest request = new RemoteRequest(httpRequest, this.formRequestMode);
        LocalResponse response = new LocalResponse(httpResponse, request.getProtocolVersion());
        if (request.getDispatcherType() == DispatcherType.ASYNC) {
            processing = (Logbook.ResponseProcessingStage)request.getAttribute(this.responseProcessingStageName);
        } else {
            processing = this.process(request).write();
            request.setAttribute(this.responseProcessingStageName, processing);
        }
        Logbook.ResponseWritingStage writing = processing.process((HttpResponse)response);
        request.setAsyncListener(Optional.of(new LogbookAsyncListener(event -> this.write(request, response, writing))));
        request.setAttribute(this.responseWritingStageSynchronizationName, new AtomicBoolean(false));
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
        if (request.isAsyncStarted()) {
            return;
        }
        this.write(request, response, writing);
    }

    private void write(RemoteRequest request, LocalResponse response, Logbook.ResponseWritingStage writing) throws IOException {
        AtomicBoolean attribute = (AtomicBoolean)request.getAttribute(this.responseWritingStageSynchronizationName);
        if (!attribute.getAndSet(true)) {
            response.flushBuffer();
            writing.write();
        }
    }

    private Logbook.RequestWritingStage process(HttpRequest request) throws IOException {
        return this.strategy == null ? this.logbook.process(request) : this.logbook.process(request, this.strategy);
    }

    @Generated
    private LogbookFilter(Logbook logbook, Strategy strategy, FormRequestMode formRequestMode) {
        this.logbook = logbook;
        this.strategy = strategy;
        this.formRequestMode = formRequestMode;
    }

    @Generated
    public LogbookFilter withFormRequestMode(FormRequestMode formRequestMode) {
        return this.formRequestMode == formRequestMode ? this : new LogbookFilter(this.logbook, this.strategy, formRequestMode);
    }
}

