/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.spring.webflux;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import lombok.Generated;
import org.springframework.util.MimeType;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Origin;
import org.zalando.logbook.spring.webflux.State;

final class ClientResponse
implements HttpResponse {
    private final org.springframework.web.reactive.function.client.ClientResponse response;
    private final AtomicReference<State> state = new AtomicReference<State.Unbuffered>(new State.Unbuffered());

    public int getStatus() {
        return this.response.rawStatusCode();
    }

    public Origin getOrigin() {
        return Origin.REMOTE;
    }

    public HttpHeaders getHeaders() {
        return HttpHeaders.of((Map)this.response.headers().asHttpHeaders());
    }

    @Nullable
    public String getContentType() {
        return Optional.ofNullable(this.response.headers().asHttpHeaders().getContentType()).map(MimeType::toString).orElse(null);
    }

    public Charset getCharset() {
        return Optional.ofNullable(this.response.headers().asHttpHeaders().getContentType()).map(MimeType::getCharset).orElse(StandardCharsets.UTF_8);
    }

    public HttpResponse withBody() throws IOException {
        this.state.updateAndGet(State::with);
        return this;
    }

    public HttpResponse withoutBody() {
        this.state.updateAndGet(State::without);
        return this;
    }

    boolean shouldBuffer() {
        return this.state.get() instanceof State.Offering;
    }

    void buffer(byte[] message) {
        this.state.updateAndGet(s -> s.buffer(message));
    }

    public byte[] getBody() throws IOException {
        return this.state.get().getBody();
    }

    @Generated
    public ClientResponse(org.springframework.web.reactive.function.client.ClientResponse response) {
        this.response = response;
    }
}

