/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.spring.webflux;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import lombok.Generated;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.MimeType;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Origin;
import org.zalando.logbook.spring.webflux.State;

final class ServerResponse
implements HttpResponse {
    private final ServerHttpResponse response;
    private final AtomicReference<State> state = new AtomicReference<State.Unbuffered>(new State.Unbuffered());

    public Origin getOrigin() {
        return Origin.LOCAL;
    }

    public HttpHeaders getHeaders() {
        return HttpHeaders.of((Map)this.response.getHeaders());
    }

    public int getStatus() {
        return Optional.ofNullable(this.response.getRawStatusCode()).orElse(200);
    }

    @Nullable
    public String getContentType() {
        return Optional.ofNullable(this.response.getHeaders().getContentType()).map(MimeType::toString).orElse(null);
    }

    public Charset getCharset() {
        return Optional.ofNullable(this.response.getHeaders().getContentType()).map(MimeType::getCharset).orElse(StandardCharsets.UTF_8);
    }

    public HttpResponse withBody() throws IOException {
        this.state.updateAndGet(State::with);
        return this;
    }

    public HttpResponse withoutBody() {
        this.state.updateAndGet(State::without);
        return this;
    }

    boolean shouldBuffer() {
        return this.state.get() instanceof State.Offering;
    }

    void buffer(byte[] message) {
        this.state.updateAndGet(s -> s.buffer(message));
    }

    public byte[] getBody() throws IOException {
        return this.state.get().getBody();
    }

    @Generated
    public ServerResponse(ServerHttpResponse response) {
        this.response = response;
    }
}

