/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.spring.webflux;

import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.client.reactive.ClientHttpRequestDecorator;
import org.zalando.logbook.spring.webflux.ClientRequest;
import org.zalando.logbook.spring.webflux.DataBufferCopyUtils;
import reactor.core.publisher.Mono;

final class BufferingClientHttpRequest
extends ClientHttpRequestDecorator {
    private final ClientRequest clientRequest;

    BufferingClientHttpRequest(ClientHttpRequest delegate, ClientRequest clientRequest) {
        super(delegate);
        this.clientRequest = clientRequest;
    }

    public Mono<Void> writeWith(Publisher<? extends DataBuffer> body) {
        return super.writeWith(this.bufferingWrap(body));
    }

    private Publisher<? extends DataBuffer> bufferingWrap(Publisher<? extends DataBuffer> body) {
        if (this.clientRequest.shouldBuffer()) {
            return DataBufferCopyUtils.wrapAndBuffer(body, this.clientRequest::buffer);
        }
        return body;
    }
}

