/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.spring.webflux;

import lombok.Generated;

interface State {
    default public State with() {
        return this;
    }

    default public State without() {
        return this;
    }

    default public State buffer(byte[] message) {
        return this;
    }

    default public byte[] getBody() {
        return new byte[0];
    }

    public static class Ignoring
    implements State {
        private final Buffering buffering;

        @Override
        public State with() {
            return this.buffering;
        }

        @Override
        public State buffer(byte[] message) {
            return this.buffering.buffer(message);
        }

        @Generated
        public Ignoring(Buffering buffering) {
            this.buffering = buffering;
        }
    }

    public static class Offering
    implements State {
        @Override
        public State without() {
            return new Unbuffered();
        }

        @Override
        public State buffer(byte[] message) {
            return new Buffering().buffer(message);
        }
    }

    public static class Unbuffered
    implements State {
        @Override
        public State with() {
            return new Offering();
        }
    }

    public static class Buffering
    implements State {
        private byte[] body;

        @Override
        public State without() {
            return new Ignoring(this);
        }

        @Override
        public State buffer(byte[] message) {
            this.body = message;
            return this;
        }

        @Override
        public byte[] getBody() {
            return this.body;
        }
    }
}

