/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.spring.webflux;

import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.zalando.logbook.spring.webflux.DataBufferCopyUtils;
import org.zalando.logbook.spring.webflux.ServerResponse;
import reactor.core.publisher.Mono;

class BufferingServerHttpResponse
extends ServerHttpResponseDecorator {
    private final ServerResponse serverResponse;

    BufferingServerHttpResponse(ServerHttpResponse delegate, ServerResponse serverResponse, Runnable writeHook) {
        super(delegate);
        this.serverResponse = serverResponse;
        this.beforeCommit(() -> {
            writeHook.run();
            return Mono.empty();
        });
    }

    public Mono<Void> writeWith(Publisher<? extends DataBuffer> body) {
        return super.writeWith(this.bufferingWrap(body));
    }

    private Publisher<? extends DataBuffer> bufferingWrap(Publisher<? extends DataBuffer> body) {
        if (this.serverResponse.shouldBuffer()) {
            return DataBufferCopyUtils.wrapAndBuffer(body, this.serverResponse::buffer);
        }
        return body;
    }
}

