/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.spring;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpResponse;

public class BufferingClientHttpResponseWrapper
implements ClientHttpResponse {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BufferingClientHttpResponseWrapper.class);
    private final ClientHttpResponse delegate;
    private final InputStream body;

    public BufferingClientHttpResponseWrapper(ClientHttpResponse delegate) throws IOException {
        this.delegate = delegate;
        delegate.getHeaders();
        InputStream delegateBody = delegate.getBody();
        this.body = delegateBody.markSupported() ? delegateBody : new BufferedInputStream(delegateBody);
    }

    @NotNull
    public HttpStatusCode getStatusCode() throws IOException {
        return this.delegate.getStatusCode();
    }

    public int getRawStatusCode() throws IOException {
        return this.delegate.getStatusCode().value();
    }

    @NotNull
    public String getStatusText() throws IOException {
        return this.delegate.getStatusText();
    }

    public void close() {
        try {
            this.body.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.delegate.close();
    }

    @NotNull
    public InputStream getBody() {
        return this.body;
    }

    @NotNull
    public HttpHeaders getHeaders() {
        return this.delegate.getHeaders();
    }
}

