/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.spring;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import lombok.Generated;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.MimeType;
import org.zalando.fauxpas.FauxPas;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Origin;
import org.zalando.logbook.spring.ByteStreams;

final class RemoteResponse
implements HttpResponse {
    private final AtomicReference<State> state = new AtomicReference<Unbuffered>(new Unbuffered());
    private final ClientHttpResponse response;

    public int getStatus() {
        try {
            return this.response.getStatusCode().value();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getProtocolVersion() {
        return "HTTP/1.1";
    }

    public Origin getOrigin() {
        return Origin.REMOTE;
    }

    public HttpHeaders getHeaders() {
        return HttpHeaders.of((Map)this.response.getHeaders());
    }

    @Nullable
    public String getContentType() {
        return Optional.ofNullable(this.response.getHeaders().getContentType()).map(MimeType::toString).orElse(null);
    }

    public Charset getCharset() {
        return Optional.ofNullable(this.response.getHeaders().getContentType()).map(MimeType::getCharset).orElse(StandardCharsets.UTF_8);
    }

    public HttpResponse withBody() {
        this.state.updateAndGet(State::with);
        return this;
    }

    public RemoteResponse withoutBody() {
        this.state.updateAndGet(State::without);
        return this;
    }

    public byte[] getBody() {
        return this.state.updateAndGet((UnaryOperator<State>)FauxPas.throwingUnaryOperator(state -> state.buffer(this.response))).getBody();
    }

    @Generated
    public RemoteResponse(ClientHttpResponse response) {
        this.response = response;
    }

    private static interface State {
        default public State with() {
            return this;
        }

        default public State without() {
            return this;
        }

        default public State buffer(ClientHttpResponse response) throws IOException {
            return this;
        }

        default public byte[] getBody() {
            return new byte[0];
        }
    }

    private static final class Unbuffered
    implements State {
        private Unbuffered() {
        }

        @Override
        public State with() {
            return new Offering();
        }
    }

    private static final class Passing
    implements State {
        private Passing() {
        }
    }

    private static final class Ignoring
    implements State {
        private final Buffering buffering;

        @Override
        public State with() {
            return this.buffering;
        }

        @Generated
        public Ignoring(Buffering buffering) {
            this.buffering = buffering;
        }
    }

    private static final class Buffering
    implements State {
        private final byte[] body;

        @Override
        public State without() {
            return new Ignoring(this);
        }

        @Override
        public byte[] getBody() {
            return this.body;
        }

        @Generated
        public Buffering(byte[] body) {
            this.body = body;
        }
    }

    private static final class Offering
    implements State {
        private Offering() {
        }

        @Override
        public State without() {
            return new Unbuffered();
        }

        @Override
        public State buffer(ClientHttpResponse response) throws IOException {
            InputStream responseBodyStream = response.getBody();
            responseBodyStream.mark(Integer.MAX_VALUE);
            byte[] data = ByteStreams.toByteArray(responseBodyStream);
            responseBodyStream.reset();
            return new Buffering(data);
        }
    }
}

