/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.test;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import lombok.Generated;
import org.apiguardian.api.API;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.Origin;
import org.zalando.logbook.attributes.HttpAttributes;

@API(status=API.Status.MAINTAINED)
public final class MockHttpRequest
implements HttpRequest {
    private String protocolVersion = "HTTP/1.1";
    private Origin origin = Origin.REMOTE;
    private String remote = "127.0.0.1";
    private String method = "GET";
    private String scheme = "http";
    private String host = "localhost";
    private Optional<Integer> port = Optional.of(80);
    private String path = "/";
    private String query = "";
    private HttpHeaders headers = HttpHeaders.empty();
    private String contentType = "text/plain";
    private Charset charset = StandardCharsets.UTF_8;
    private String bodyAsString = "";
    private HttpAttributes httpAttributes = HttpAttributes.EMPTY;

    public byte[] getBody() {
        return this.bodyAsString.getBytes(StandardCharsets.UTF_8);
    }

    public HttpRequest withBody() {
        return this;
    }

    public HttpRequest withoutBody() {
        this.bodyAsString = "";
        return this;
    }

    public HttpAttributes getAttributes() {
        return this.httpAttributes;
    }

    @Generated
    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    @Generated
    public Origin getOrigin() {
        return this.origin;
    }

    @Generated
    public String getRemote() {
        return this.remote;
    }

    @Generated
    public String getMethod() {
        return this.method;
    }

    @Generated
    public String getScheme() {
        return this.scheme;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public Optional<Integer> getPort() {
        return this.port;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getQuery() {
        return this.query;
    }

    @Generated
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Generated
    public String getContentType() {
        return this.contentType;
    }

    @Generated
    public Charset getCharset() {
        return this.charset;
    }

    @Generated
    public String getBodyAsString() {
        return this.bodyAsString;
    }

    @Generated
    public HttpAttributes getHttpAttributes() {
        return this.httpAttributes;
    }

    @Generated
    public MockHttpRequest withProtocolVersion(String protocolVersion) {
        return this.protocolVersion == protocolVersion ? this : new MockHttpRequest(protocolVersion, this.origin, this.remote, this.method, this.scheme, this.host, this.port, this.path, this.query, this.headers, this.contentType, this.charset, this.bodyAsString, this.httpAttributes);
    }

    @Generated
    public MockHttpRequest withOrigin(Origin origin) {
        return this.origin == origin ? this : new MockHttpRequest(this.protocolVersion, origin, this.remote, this.method, this.scheme, this.host, this.port, this.path, this.query, this.headers, this.contentType, this.charset, this.bodyAsString, this.httpAttributes);
    }

    @Generated
    public MockHttpRequest withRemote(String remote) {
        return this.remote == remote ? this : new MockHttpRequest(this.protocolVersion, this.origin, remote, this.method, this.scheme, this.host, this.port, this.path, this.query, this.headers, this.contentType, this.charset, this.bodyAsString, this.httpAttributes);
    }

    @Generated
    public MockHttpRequest withMethod(String method) {
        return this.method == method ? this : new MockHttpRequest(this.protocolVersion, this.origin, this.remote, method, this.scheme, this.host, this.port, this.path, this.query, this.headers, this.contentType, this.charset, this.bodyAsString, this.httpAttributes);
    }

    @Generated
    public MockHttpRequest withScheme(String scheme) {
        return this.scheme == scheme ? this : new MockHttpRequest(this.protocolVersion, this.origin, this.remote, this.method, scheme, this.host, this.port, this.path, this.query, this.headers, this.contentType, this.charset, this.bodyAsString, this.httpAttributes);
    }

    @Generated
    public MockHttpRequest withHost(String host) {
        return this.host == host ? this : new MockHttpRequest(this.protocolVersion, this.origin, this.remote, this.method, this.scheme, host, this.port, this.path, this.query, this.headers, this.contentType, this.charset, this.bodyAsString, this.httpAttributes);
    }

    @Generated
    public MockHttpRequest withPort(Optional<Integer> port) {
        return this.port == port ? this : new MockHttpRequest(this.protocolVersion, this.origin, this.remote, this.method, this.scheme, this.host, port, this.path, this.query, this.headers, this.contentType, this.charset, this.bodyAsString, this.httpAttributes);
    }

    @Generated
    public MockHttpRequest withPath(String path) {
        return this.path == path ? this : new MockHttpRequest(this.protocolVersion, this.origin, this.remote, this.method, this.scheme, this.host, this.port, path, this.query, this.headers, this.contentType, this.charset, this.bodyAsString, this.httpAttributes);
    }

    @Generated
    public MockHttpRequest withQuery(String query) {
        return this.query == query ? this : new MockHttpRequest(this.protocolVersion, this.origin, this.remote, this.method, this.scheme, this.host, this.port, this.path, query, this.headers, this.contentType, this.charset, this.bodyAsString, this.httpAttributes);
    }

    @Generated
    public MockHttpRequest withHeaders(HttpHeaders headers) {
        return this.headers == headers ? this : new MockHttpRequest(this.protocolVersion, this.origin, this.remote, this.method, this.scheme, this.host, this.port, this.path, this.query, headers, this.contentType, this.charset, this.bodyAsString, this.httpAttributes);
    }

    @Generated
    public MockHttpRequest withContentType(String contentType) {
        return this.contentType == contentType ? this : new MockHttpRequest(this.protocolVersion, this.origin, this.remote, this.method, this.scheme, this.host, this.port, this.path, this.query, this.headers, contentType, this.charset, this.bodyAsString, this.httpAttributes);
    }

    @Generated
    public MockHttpRequest withCharset(Charset charset) {
        return this.charset == charset ? this : new MockHttpRequest(this.protocolVersion, this.origin, this.remote, this.method, this.scheme, this.host, this.port, this.path, this.query, this.headers, this.contentType, charset, this.bodyAsString, this.httpAttributes);
    }

    @Generated
    public MockHttpRequest withBodyAsString(String bodyAsString) {
        return this.bodyAsString == bodyAsString ? this : new MockHttpRequest(this.protocolVersion, this.origin, this.remote, this.method, this.scheme, this.host, this.port, this.path, this.query, this.headers, this.contentType, this.charset, bodyAsString, this.httpAttributes);
    }

    @Generated
    public MockHttpRequest withHttpAttributes(HttpAttributes httpAttributes) {
        return this.httpAttributes == httpAttributes ? this : new MockHttpRequest(this.protocolVersion, this.origin, this.remote, this.method, this.scheme, this.host, this.port, this.path, this.query, this.headers, this.contentType, this.charset, this.bodyAsString, httpAttributes);
    }

    @Generated
    private MockHttpRequest() {
    }

    @Generated
    public static MockHttpRequest create() {
        return new MockHttpRequest();
    }

    @Generated
    public MockHttpRequest(String protocolVersion, Origin origin, String remote, String method, String scheme, String host, Optional<Integer> port, String path, String query, HttpHeaders headers, String contentType, Charset charset, String bodyAsString, HttpAttributes httpAttributes) {
        this.protocolVersion = protocolVersion;
        this.origin = origin;
        this.remote = remote;
        this.method = method;
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.path = path;
        this.query = query;
        this.headers = headers;
        this.contentType = contentType;
        this.charset = charset;
        this.bodyAsString = bodyAsString;
        this.httpAttributes = httpAttributes;
    }
}

