/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.config;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.zalando.nakadi.config.SecuritySettings;
import org.zalando.stups.oauth2.spring.server.TokenInfoResourceServerTokenServices;

@Configuration
@Profile(value={"!test"})
public class AuthenticationConfig {
    @Bean
    public ResourceServerTokenServices zalandoResourceTokenServices(SecuritySettings settings, MetricRegistry metricRegistry) {
        return new MeasuringTokenInfoResourceServerTokenServices(settings.getTokenInfoUrl(), settings.getClientId(), metricRegistry);
    }

    public static class MeasuringTokenInfoResourceServerTokenServices
    extends TokenInfoResourceServerTokenServices {
        private final Timer timer;

        public MeasuringTokenInfoResourceServerTokenServices(String tokenInfoEndpointUrl, String clientId, MetricRegistry metricRegistry) {
            super(tokenInfoEndpointUrl, clientId);
            this.timer = metricRegistry.timer("nakadi.general.accessTokenValidation");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OAuth2Authentication loadAuthentication(String accessToken) throws AuthenticationException {
            Timer.Context context = this.timer.time();
            try {
                OAuth2Authentication oAuth2Authentication = super.loadAuthentication(accessToken);
                return oAuth2Authentication;
            }
            finally {
                context.stop();
            }
        }
    }
}

