/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"!test"})
public class SecuritySettings {
    private final String tokenInfoUrl;
    private final String clientId;
    private final AuthMode authMode;
    private final String adminClientId;

    @Autowired
    public SecuritySettings(@Value(value="${nakadi.oauth2.tokenInfoUrl}") String tokenInfoUrl, @Value(value="${nakadi.oauth2.clientId}") String clientId, @Value(value="${nakadi.oauth2.mode:BASIC}") AuthMode authMode, @Value(value="${nakadi.oauth2.adminClientId}") String adminClientId) {
        this.tokenInfoUrl = tokenInfoUrl;
        this.clientId = clientId;
        this.authMode = authMode;
        this.adminClientId = adminClientId;
    }

    public String getTokenInfoUrl() {
        return this.tokenInfoUrl;
    }

    public String getClientId() {
        return this.clientId;
    }

    public AuthMode getAuthMode() {
        return this.authMode;
    }

    public String getAdminClientId() {
        return this.adminClientId;
    }

    public static enum AuthMode {
        OFF,
        BASIC,
        FULL;

    }
}

