/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.controller;

import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.NativeWebRequest;
import org.zalando.nakadi.domain.EventType;
import org.zalando.nakadi.problem.ValidationProblem;
import org.zalando.nakadi.security.Client;
import org.zalando.nakadi.service.EventTypeService;
import org.zalando.nakadi.service.Result;
import org.zalando.nakadi.util.FeatureToggleService;
import org.zalando.nakadi.validation.EventTypeOptionsValidator;
import org.zalando.problem.Problem;
import org.zalando.problem.spring.web.advice.Responses;

@RestController
@RequestMapping(value={"/event-types"})
public class EventTypeController {
    private final EventTypeService eventTypeService;
    private final FeatureToggleService featureToggleService;
    private final EventTypeOptionsValidator eventTypeOptionsValidator;

    @Autowired
    public EventTypeController(EventTypeService eventTypeService, FeatureToggleService featureToggleService, EventTypeOptionsValidator eventTypeOptionsValidator) {
        this.eventTypeService = eventTypeService;
        this.featureToggleService = featureToggleService;
        this.eventTypeOptionsValidator = eventTypeOptionsValidator;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ResponseEntity<?> list() {
        List<EventType> eventTypes = this.eventTypeService.list();
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(eventTypes);
    }

    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<?> create(@Valid @RequestBody EventType eventType, Errors errors, NativeWebRequest request) {
        if (this.featureToggleService.isFeatureEnabled(FeatureToggleService.Feature.DISABLE_EVENT_TYPE_CREATION)) {
            return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
        }
        ValidationUtils.invokeValidator((Validator)this.eventTypeOptionsValidator, (Object)eventType.getOptions(), (Errors)errors);
        if (errors.hasErrors()) {
            return Responses.create((Problem)new ValidationProblem(errors), (NativeWebRequest)request);
        }
        Result<Void> result = this.eventTypeService.create(eventType);
        if (!result.isSuccessful()) {
            return Responses.create((Problem)result.getProblem(), (NativeWebRequest)request);
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).build();
    }

    @RequestMapping(value={"/{name:.+}"}, method={RequestMethod.DELETE})
    public ResponseEntity<?> delete(@PathVariable(value="name") String eventTypeName, NativeWebRequest request, Client client) {
        if (this.featureToggleService.isFeatureEnabled(FeatureToggleService.Feature.DISABLE_EVENT_TYPE_DELETION)) {
            return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
        }
        Result<Void> result = this.eventTypeService.delete(eventTypeName, client);
        if (!result.isSuccessful()) {
            return Responses.create((Problem)result.getProblem(), (NativeWebRequest)request);
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).build();
    }

    @RequestMapping(value={"/{name:.+}"}, method={RequestMethod.PUT})
    public ResponseEntity<?> update(@PathVariable(value="name") String name, @RequestBody @Valid EventType eventType, Errors errors, NativeWebRequest request, Client client) {
        if (errors.hasErrors()) {
            return Responses.create((Problem)new ValidationProblem(errors), (NativeWebRequest)request);
        }
        Result<Void> update = this.eventTypeService.update(name, eventType, client);
        if (!update.isSuccessful()) {
            return Responses.create((Problem)update.getProblem(), (NativeWebRequest)request);
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).build();
    }

    @RequestMapping(value={"/{name:.+}"}, method={RequestMethod.GET})
    public ResponseEntity<?> get(@PathVariable String name, NativeWebRequest request) {
        Result<EventType> result = this.eventTypeService.get(name);
        if (!result.isSuccessful()) {
            return Responses.create((Problem)result.getProblem(), (NativeWebRequest)request);
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)result.getValue());
    }
}

