/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.controller;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.CaseFormat;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.NativeWebRequest;
import org.zalando.problem.Problem;
import org.zalando.problem.spring.web.advice.ProblemHandling;
import org.zalando.problem.spring.web.advice.Responses;

@ControllerAdvice
public final class ExceptionHandling
implements ProblemHandling {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionHandling.class);

    public String formatFieldName(String fieldName) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, fieldName);
    }

    @ExceptionHandler
    public ResponseEntity<Problem> handleThrowable(Throwable throwable, NativeWebRequest request) {
        String errorTraceId = this.generateErrorTraceId();
        LOG.error("InternalServerError (" + errorTraceId + "):", throwable);
        return Responses.create((Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, (String)("An internal error happened. Please report it. (" + errorTraceId + ")"), (NativeWebRequest)request);
    }

    private String generateErrorTraceId() {
        return "ETI" + RandomStringUtils.randomAlphanumeric((int)24);
    }

    @ExceptionHandler
    public ResponseEntity<Problem> handleMessageNotReadableException(HttpMessageNotReadableException exception, NativeWebRequest request) {
        Throwable mostSpecificCause = exception.getMostSpecificCause();
        String message = mostSpecificCause instanceof JsonMappingException ? mostSpecificCause.getMessage() : exception.getMessage();
        return Responses.create((Response.StatusType)Response.Status.BAD_REQUEST, (String)message, (NativeWebRequest)request);
    }
}

