/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.controller;

import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.NativeWebRequest;
import org.zalando.nakadi.domain.EventType;
import org.zalando.nakadi.exceptions.NakadiException;
import org.zalando.nakadi.exceptions.NoSuchEventTypeException;
import org.zalando.nakadi.repository.EventTypeRepository;
import org.zalando.nakadi.repository.TopicRepository;
import org.zalando.problem.Problem;
import org.zalando.problem.spring.web.advice.Responses;

@RestController
public class PartitionsController {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionsController.class);
    private final EventTypeRepository eventTypeRepository;
    private final TopicRepository topicRepository;

    @Autowired
    public PartitionsController(EventTypeRepository eventTypeRepository, TopicRepository topicRepository) {
        this.eventTypeRepository = eventTypeRepository;
        this.topicRepository = topicRepository;
    }

    @RequestMapping(value={"/event-types/{name}/partitions"}, method={RequestMethod.GET})
    public ResponseEntity<?> listPartitions(@PathVariable(value="name") String eventTypeName, NativeWebRequest request) {
        LOG.trace("Get partitions endpoint for event-type '{}' is called", (Object)eventTypeName);
        try {
            EventType eventType = this.eventTypeRepository.findByName(eventTypeName);
            if (!this.topicRepository.topicExists(eventType.getTopic())) {
                return Responses.create((Problem)Problem.valueOf((Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, (String)"topic is absent in kafka"), (NativeWebRequest)request);
            }
            return ResponseEntity.ok().body(this.topicRepository.listPartitions(eventType.getTopic()));
        }
        catch (NoSuchEventTypeException e) {
            return Responses.create((Problem)Problem.valueOf((Response.StatusType)Response.Status.NOT_FOUND, (String)"topic not found"), (NativeWebRequest)request);
        }
        catch (NakadiException e) {
            LOG.error("Could not list partitions. Respond with SERVICE_UNAVAILABLE.", (Throwable)e);
            return Responses.create((Problem)e.asProblem(), (NativeWebRequest)request);
        }
    }

    @RequestMapping(value={"/event-types/{name}/partitions/{partition}"}, method={RequestMethod.GET})
    public ResponseEntity<?> getPartition(@PathVariable(value="name") String eventTypeName, @PathVariable(value="partition") String partition, NativeWebRequest request) {
        LOG.trace("Get partition endpoint for event-type '{}', partition '{}' is called", (Object)eventTypeName, (Object)partition);
        try {
            EventType eventType = this.eventTypeRepository.findByName(eventTypeName);
            String topic = eventType.getTopic();
            if (!this.topicRepository.topicExists(topic)) {
                return Responses.create((Problem)Problem.valueOf((Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, (String)"topic is absent in kafka"), (NativeWebRequest)request);
            }
            if (!this.topicRepository.partitionExists(topic, partition)) {
                return Responses.create((Problem)Problem.valueOf((Response.StatusType)Response.Status.NOT_FOUND, (String)"partition not found"), (NativeWebRequest)request);
            }
            return ResponseEntity.ok().body((Object)this.topicRepository.getPartition(topic, partition));
        }
        catch (NoSuchEventTypeException e) {
            return Responses.create((Problem)Problem.valueOf((Response.StatusType)Response.Status.NOT_FOUND, (String)"topic not found"), (NativeWebRequest)request);
        }
        catch (NakadiException e) {
            LOG.error("Could not get partition. Respond with SERVICE_UNAVAILABLE.", (Throwable)e);
            return Responses.create((Problem)e.asProblem(), (NativeWebRequest)request);
        }
    }
}

