/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.domain;

import java.util.Optional;
import org.json.JSONObject;
import org.zalando.nakadi.domain.BatchItemResponse;
import org.zalando.nakadi.domain.EventPublishingStatus;
import org.zalando.nakadi.domain.EventPublishingStep;

public class BatchItem {
    private final BatchItemResponse response = new BatchItemResponse();
    private final JSONObject event;
    private String partition;

    public BatchItem(JSONObject event) {
        this.event = event;
        Optional.ofNullable(event.optJSONObject("metadata")).map(e -> e.optString("eid", null)).ifPresent(this.response::setEid);
    }

    public JSONObject getEvent() {
        return this.event;
    }

    public void setPartition(String partition) {
        this.partition = partition;
    }

    public String getPartition() {
        return this.partition;
    }

    public BatchItemResponse getResponse() {
        return this.response;
    }

    public void setStep(EventPublishingStep step) {
        this.response.setStep(step);
    }

    public synchronized void updateStatusAndDetail(EventPublishingStatus publishingStatus, String detail) {
        this.response.setPublishingStatus(publishingStatus);
        this.response.setDetail(detail);
    }
}

