/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.zalando.nakadi.domain.EnrichmentStrategyDescriptor;
import org.zalando.nakadi.domain.EventCategory;
import org.zalando.nakadi.domain.EventTypeOptions;
import org.zalando.nakadi.domain.EventTypeSchema;
import org.zalando.nakadi.domain.EventTypeStatistics;
import org.zalando.nakadi.domain.ValidationStrategyConfiguration;

public class EventType {
    public static final List<String> EMPTY_STRING_LIST = new ArrayList<String>(0);
    @NotNull
    @Pattern(regexp="[a-zA-Z][-0-9a-zA-Z_]*(\\.[a-zA-Z][-0-9a-zA-Z_]*)*", message="format not allowed")
    @Size(min=1, max=255, message="the length of the name must be >= 1 and <= 255")
    private String name;
    @JsonIgnore
    private String topic;
    @NotNull
    private String owningApplication;
    @NotNull
    private EventCategory category;
    @JsonIgnore
    private final List<ValidationStrategyConfiguration> validationStrategies = Lists.newArrayList();
    @NotNull
    private List<EnrichmentStrategyDescriptor> enrichmentStrategies = Lists.newArrayList();
    private String partitionStrategy = "random";
    @Nullable
    private List<String> partitionKeyFields;
    @Valid
    @NotNull
    private EventTypeSchema schema;
    @Valid
    @Nullable
    private EventTypeStatistics defaultStatistic;
    @Valid
    @Nullable
    private EventTypeOptions options;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOwningApplication() {
        return this.owningApplication;
    }

    public void setOwningApplication(String owningApplication) {
        this.owningApplication = owningApplication;
    }

    public EventCategory getCategory() {
        return this.category;
    }

    public void setCategory(EventCategory category) {
        this.category = category;
    }

    public List<ValidationStrategyConfiguration> getValidationStrategies() {
        return this.validationStrategies;
    }

    public String getPartitionStrategy() {
        return this.partitionStrategy;
    }

    public void setPartitionStrategy(String partitionStrategy) {
        this.partitionStrategy = partitionStrategy;
    }

    public EventTypeSchema getSchema() {
        return this.schema;
    }

    public void setSchema(EventTypeSchema schema) {
        this.schema = schema;
    }

    public EventTypeStatistics getDefaultStatistic() {
        return this.defaultStatistic;
    }

    public void setDefaultStatistic(EventTypeStatistics defaultStatistic) {
        this.defaultStatistic = defaultStatistic;
    }

    public List<String> getPartitionKeyFields() {
        return Collections.unmodifiableList(this.partitionKeyFields != null ? this.partitionKeyFields : EMPTY_STRING_LIST);
    }

    public void setPartitionKeyFields(List<String> partitionKeyFields) {
        this.partitionKeyFields = partitionKeyFields;
    }

    public List<EnrichmentStrategyDescriptor> getEnrichmentStrategies() {
        return this.enrichmentStrategies;
    }

    public void setEnrichmentStrategies(List<EnrichmentStrategyDescriptor> enrichmentStrategies) {
        this.enrichmentStrategies = enrichmentStrategies;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public EventTypeOptions getOptions() {
        return this.options;
    }

    public void setOptions(EventTypeOptions options) {
        this.options = options;
    }
}

