/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.domain;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class SubscriptionBase {
    @NotNull
    private String owningApplication;
    @NotNull
    @Size(min=1, max=1)
    private Set<String> eventTypes;
    @NotNull
    private String consumerGroup = "none";
    @NotNull
    private InitialPosition startFrom = InitialPosition.END;

    public SubscriptionBase() {
    }

    public SubscriptionBase(SubscriptionBase subscriptionBase) {
        this.setOwningApplication(subscriptionBase.getOwningApplication());
        this.setEventTypes(subscriptionBase.getEventTypes());
        this.setConsumerGroup(subscriptionBase.getConsumerGroup());
        this.setStartFrom(subscriptionBase.getStartFrom());
    }

    public String getOwningApplication() {
        return this.owningApplication;
    }

    public void setOwningApplication(String owningApplication) {
        this.owningApplication = owningApplication;
    }

    public Set<String> getEventTypes() {
        return Collections.unmodifiableSet(this.eventTypes);
    }

    public void setEventTypes(Set<String> eventTypes) {
        this.eventTypes = Sets.newTreeSet(eventTypes);
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }

    public InitialPosition getStartFrom() {
        return this.startFrom;
    }

    public void setStartFrom(InitialPosition startFrom) {
        this.startFrom = startFrom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionBase that = (SubscriptionBase)o;
        return this.owningApplication.equals(that.owningApplication) && this.eventTypes.equals(that.eventTypes) && this.consumerGroup.equals(that.consumerGroup) && this.startFrom.equals((Object)that.startFrom);
    }

    public int hashCode() {
        int result = this.owningApplication != null ? this.owningApplication.hashCode() : 0;
        result = 31 * result + (this.eventTypes != null ? this.eventTypes.hashCode() : 0);
        result = 31 * result + (this.consumerGroup != null ? this.consumerGroup.hashCode() : 0);
        result = 31 * result + (this.startFrom != null ? this.startFrom.hashCode() : 0);
        return result;
    }

    public static enum InitialPosition {
        BEGIN,
        END;

    }
}

