/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.enrichment;

import java.util.HashSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.zalando.nakadi.domain.BatchItem;
import org.zalando.nakadi.domain.EnrichmentStrategyDescriptor;
import org.zalando.nakadi.domain.EventCategory;
import org.zalando.nakadi.domain.EventType;
import org.zalando.nakadi.enrichment.EnrichmentStrategy;
import org.zalando.nakadi.enrichment.EnrichmentsRegistry;
import org.zalando.nakadi.exceptions.EnrichmentException;
import org.zalando.nakadi.exceptions.InvalidEventTypeException;

@Component
public class Enrichment {
    private final EnrichmentsRegistry registry;

    @Autowired
    public Enrichment(EnrichmentsRegistry registry) {
        this.registry = registry;
    }

    public void validate(EventType eventType) throws InvalidEventTypeException {
        if (eventType.getCategory() == EventCategory.UNDEFINED && !eventType.getEnrichmentStrategies().isEmpty()) {
            throw new InvalidEventTypeException("must not define enrichment strategy for undefined event type");
        }
        HashSet<EnrichmentStrategyDescriptor> uniqueStrategies = new HashSet<EnrichmentStrategyDescriptor>(eventType.getEnrichmentStrategies());
        if (eventType.getEnrichmentStrategies().size() != uniqueStrategies.size()) {
            throw new InvalidEventTypeException("enrichment strategies must not contain duplicated entries");
        }
        if (eventType.getCategory() != EventCategory.UNDEFINED && !eventType.getEnrichmentStrategies().contains((Object)EnrichmentStrategyDescriptor.METADATA_ENRICHMENT)) {
            throw new InvalidEventTypeException("must define metadata enrichment strategy");
        }
    }

    public void enrich(BatchItem batchItem, EventType eventType) throws EnrichmentException {
        for (EnrichmentStrategyDescriptor descriptor : eventType.getEnrichmentStrategies()) {
            EnrichmentStrategy strategy = this.getStrategy(descriptor);
            strategy.enrich(batchItem, eventType);
        }
    }

    private EnrichmentStrategy getStrategy(EnrichmentStrategyDescriptor enrichmentStrategyDescriptor) {
        return this.registry.getStrategy(enrichmentStrategyDescriptor);
    }
}

