/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.enrichment;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.json.JSONException;
import org.json.JSONObject;
import org.zalando.nakadi.domain.BatchItem;
import org.zalando.nakadi.domain.EventType;
import org.zalando.nakadi.enrichment.EnrichmentStrategy;
import org.zalando.nakadi.exceptions.EnrichmentException;
import org.zalando.nakadi.util.FlowIdUtils;

public class MetadataEnrichmentStrategy
implements EnrichmentStrategy {
    @Override
    public void enrich(BatchItem batchItem, EventType eventType) throws EnrichmentException {
        try {
            JSONObject metadata = batchItem.getEvent().getJSONObject("metadata");
            this.setReceivedAt(metadata);
            this.setEventTypeName(metadata, eventType);
            this.setFlowId(metadata);
            this.setPartition(metadata, batchItem);
        }
        catch (JSONException e) {
            throw new EnrichmentException("enrichment error", (Exception)((Object)e));
        }
    }

    private void setFlowId(JSONObject metadata) {
        metadata.put("flow_id", (Object)FlowIdUtils.peek());
    }

    private void setEventTypeName(JSONObject metadata, EventType eventType) {
        metadata.put("event_type", (Object)eventType.getName());
    }

    private void setReceivedAt(JSONObject metadata) {
        DateTime dateTime = new DateTime(DateTimeZone.UTC);
        metadata.put("received_at", (Object)dateTime.toString());
    }

    public void setPartition(JSONObject metadata, BatchItem batchItem) {
        metadata.put("partition", (Object)batchItem.getPartition());
    }
}

